/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api_impl;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.IAppleCoreDispatcher;
import squeek.applecore.api.plants.PlantGrowthEvent;

public enum AppleCoreDispatcherImpl implements IAppleCoreDispatcher
{
    INSTANCE;

    private static Random random;

    private AppleCoreDispatcherImpl() {
        AppleCoreAPI.dispatcher = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public Event.Result validatePlantGrowth(Block block, World world, BlockPos pos, IBlockState state, Random random) {
        BlockEvent.CropGrowEvent.Pre event = new BlockEvent.CropGrowEvent.Pre(world, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    @Override
    public void announcePlantGrowth(Block block, World world, BlockPos pos, IBlockState currentState, IBlockState previousState) {
        BlockEvent.CropGrowEvent.Post event = new BlockEvent.CropGrowEvent.Post(world, pos, previousState, currentState);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public void announcePlantGrowth(Block block, World world, BlockPos pos, IBlockState previousState) {
        BlockEvent.CropGrowEvent.Post event = new BlockEvent.CropGrowEvent.Post(world, pos, previousState, world.func_180495_p(pos));
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @SubscribeEvent
    public void onCropGrowEventPre(BlockEvent.CropGrowEvent.Pre event) {
        PlantGrowthEvent.AllowGrowthTick appleCoreEvent = new PlantGrowthEvent.AllowGrowthTick(event.getState().func_177230_c(), event.getWorld(), event.getPos(), event.getState(), random);
        appleCoreEvent.setResult(event.getResult());
        MinecraftForge.EVENT_BUS.post((Event)appleCoreEvent);
        event.setResult(appleCoreEvent.getResult());
    }

    @SubscribeEvent
    public void onCropGrowEventPost(BlockEvent.CropGrowEvent.Post event) {
        PlantGrowthEvent.GrowthTick appleCoreEvent = new PlantGrowthEvent.GrowthTick(event.getState().func_177230_c(), event.getWorld(), event.getPos(), event.getState(), event.getOriginalState());
        MinecraftForge.EVENT_BUS.post((Event)appleCoreEvent);
    }
}

