/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.funnels;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.shadowfacts.funnels.BlockFunnel;
import net.shadowfacts.funnels.FluidUtils;
import net.shadowfacts.funnels.FunnelsConfig;
import net.shadowfacts.shadowmc.ShadowMC;
import net.shadowfacts.shadowmc.capability.CapHolder;
import net.shadowfacts.shadowmc.fluid.FluidTank;
import net.shadowfacts.shadowmc.nbt.AutoSerializeNBT;
import net.shadowfacts.shadowmc.network.PacketUpdateTE;
import net.shadowfacts.shadowmc.tileentity.BaseTileEntity;

public class TileEntityFunnel
extends BaseTileEntity
implements ITickable {
    @AutoSerializeNBT
    @CapHolder(capabilities={IFluidHandler.class})
    FluidTank tank = new FluidTank(FunnelsConfig.size);
    private int tick;

    void save() {
        this.func_70296_d();
        ShadowMC.network.sendToAllAround((IMessage)new PacketUpdateTE((BaseTileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            EnumFacing facing;
            BlockPos handlerPos;
            TileEntity te;
            BlockPos handlerPos2;
            TileEntity te2;
            if (this.tank.getFluidAmount() < this.tank.getCapacity() && (te2 = this.field_145850_b.func_175625_s(handlerPos2 = this.field_174879_c.func_177984_a())) != null && te2.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                IFluidHandler handler = (IFluidHandler)te2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
                this.tank.fill(handler.drain(this.tank.getCapacity() - this.tank.getFluidAmount(), true), true);
                this.save();
            } else if (this.tank.getFluidAmount() > 0 && (te = this.field_145850_b.func_175625_s(handlerPos = this.field_174879_c.func_177972_a(facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFunnel.FACING)))) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
                IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                this.tank.drain(handler.fill(this.tank.drain(20, false), true), true);
                this.save();
            }
            ++this.tick;
            if (this.tick % 40 == 0) {
                FluidStack fluid;
                if (FunnelsConfig.pickupWorldFluids && this.tank.getFluidAmount() <= this.tank.getCapacity() - 1000) {
                    this.tick = 0;
                    if (FluidUtils.isFluidBlock(this.field_145850_b, this.field_174879_c.func_177984_a())) {
                        FluidStack toDrain = FluidUtils.drainFluidBlock(this.field_145850_b, this.field_174879_c.func_177984_a(), false);
                        if (toDrain.amount <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
                            this.tank.fill(FluidUtils.drainFluidBlock(this.field_145850_b, this.field_174879_c.func_177984_a(), true), true);
                            this.save();
                            return;
                        }
                    }
                }
                if (FunnelsConfig.placeFluidsInWorld && this.tank.getFluidAmount() >= 1000 && (fluid = this.tank.getFluid()).getFluid().canBePlacedInWorld()) {
                    BlockPos newPos;
                    Block fluidBlock = fluid.getFluid().getBlock();
                    if (fluidBlock instanceof BlockLiquid) {
                        fluidBlock = BlockLiquid.func_176361_a((Material)fluidBlock.func_176223_P().func_185904_a());
                    }
                    if (fluidBlock.func_176196_c(this.field_145850_b, newPos = this.field_174879_c.func_177972_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFunnel.FACING)))) {
                        this.tank.drain(1000, true);
                        this.save();
                        this.field_145850_b.func_175656_a(newPos, fluidBlock.func_176223_P());
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        return tag;
    }
}

