/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.funnels;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.shadowfacts.funnels.FluidUtils;
import net.shadowfacts.funnels.TileEntityFunnel;
import net.shadowfacts.shadowmc.block.BlockTE;

public class BlockFunnel
extends BlockTE<TileEntityFunnel> {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", side -> side != EnumFacing.UP);
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockFunnel() {
        super(Material.field_151573_f, "funnel");
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing side = facing.func_176734_d();
        if (side == EnumFacing.UP) {
            side = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)side);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            TileEntityFunnel te = (TileEntityFunnel)this.getTileEntity((IBlockAccess)world, pos);
            if (FluidUtils.fillHandlerWithContainer(world, (IFluidHandler)te.tank, player, hand)) {
                te.save();
                return true;
            }
            if (FluidUtils.fillContainerFromHandler(world, (IFluidHandler)te.tank, player, hand, te.tank.getFluid())) {
                te.save();
                return true;
            }
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Class<TileEntityFunnel> getTileEntityClass() {
        return TileEntityFunnel.class;
    }

    @Nonnull
    public TileEntityFunnel createTileEntity(World world, IBlockState state) {
        return new TileEntityFunnel();
    }
}

