/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.net.serverbound;

import com.pau101.fairylights.server.fastener.connection.FeatureType;
import com.pau101.fairylights.server.fastener.connection.PlayerAction;
import com.pau101.fairylights.server.fastener.connection.collision.Intersection;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.net.MessageConnection;
import com.pau101.fairylights.util.Utils;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public final class MessageConnectionInteraction
extends MessageConnection<Connection> {
    private static final float RANGE = 1089.0f;
    private static final float REACH = 36.0f;
    private PlayerAction type;
    private Vec3d hit;
    private FeatureType featureType;
    private int featureId;

    public MessageConnectionInteraction() {
    }

    public MessageConnectionInteraction(Connection connection, PlayerAction type, Intersection intersection) {
        super(connection);
        this.type = type;
        this.hit = intersection.getResult().field_72307_f;
        this.featureType = intersection.getFeatureType();
        this.featureId = intersection.getFeature().getId();
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeDouble(this.hit.field_72450_a);
        buf.writeDouble(this.hit.field_72448_b);
        buf.writeDouble(this.hit.field_72449_c);
        buf.func_150787_b(this.featureType.getId());
        buf.func_150787_b(this.featureId);
    }

    @Override
    public void deserialize(PacketBuffer buf) throws IOException {
        super.deserialize(buf);
        this.type = Utils.getEnumValue(PlayerAction.class, buf.readUnsignedByte());
        this.hit = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.featureType = FeatureType.fromId(buf.func_150792_a());
        this.featureId = buf.func_150792_a();
    }

    @Override
    protected boolean isInstanceOfType(Class<? extends Connection> connection) {
        return true;
    }

    @Override
    protected World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }

    @Override
    protected void process(MessageContext ctx, Connection connection) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player.func_174818_b(connection.getFastener().getPos()) < 1089.0 && player.func_70092_e(this.hit.field_72450_a, this.hit.field_72448_b, this.hit.field_72449_c) < 36.0) {
            if (this.type == PlayerAction.ATTACK) {
                connection.disconnect((EntityPlayer)player, this.hit);
            } else {
                this.interact((EntityPlayer)player, connection, this.hit);
            }
        }
    }

    private void interact(EntityPlayer player, Connection connection, Vec3d hit) {
        for (EnumHand hand : EnumHand.values()) {
            ItemStack oldStack;
            ItemStack stack = player.func_184586_b(hand);
            ItemStack itemStack = oldStack = stack == null ? null : stack.func_77946_l();
            if (!connection.interact(player, hit, this.featureType, this.featureId, stack, hand)) continue;
            this.updateItem(player, oldStack, stack, hand);
            break;
        }
    }

    private void updateItem(EntityPlayer player, ItemStack oldStack, @Nullable ItemStack stack, EnumHand hand) {
        if (stack != null && stack == player.func_184586_b(hand)) {
            if (stack.field_77994_a <= 0 && !player.field_71075_bZ.field_75098_d) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)hand);
                player.func_184611_a(hand, null);
            } else if (stack.field_77994_a < oldStack.field_77994_a && player.field_71075_bZ.field_75098_d) {
                stack.field_77994_a = oldStack.field_77994_a;
            }
        }
    }
}

