/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page.unit;

import engineers.workshop.client.GuiBase;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingGrid;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingOutput;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingResult;
import engineers.workshop.client.container.slot.crafting.SlotUnitCraftingStorage;
import engineers.workshop.client.page.Page;
import engineers.workshop.client.page.unit.Unit;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UnitCraft
extends Unit {
    private static final int START_X = 5;
    private static final int START_Y = 5;
    private static final int SLOT_SIZE = 18;
    private static final int GRID_WIDTH = 3;
    private static final int GRID_HEIGHT = 3;
    public static final int GRID_SIZE = 9;
    private static final int RESULT_OFFSET_X = 94;
    private static final int RESULT_OFFSET_Y = 18;
    public static final int RESULT_AUTO_OFFSET = -5;
    private static final int STORAGE_COUNT = 6;
    private static final int STORAGE_Y = 65;
    private static final int ARROW_X = 61;
    private static final int ARROW_Y = 19;
    private int gridId;
    private int resultId;
    private int outputId;
    private static final int CLEAR_SRC_X = 48;
    private static final int CLEAR_SRC_Y = 112;
    private static final int CLEAR_SIZE = 9;
    private static final int CLEAR_OFFSET_X = 3;
    private static final int CLEAR_OFFSET_Y = 0;
    private CraftingBase inventoryCrafting = new CraftingWrapper();
    private boolean canAutoCraft;
    private boolean lockedRecipeGeneration;
    private int canCraftTick = 0;
    private static final int CAN_CRAFT_DELAY = 10;
    private CraftingBase oldGrid;
    private static final IRecipe REPAIR_RECIPE = new RepairRecipe();

    public UnitCraft(TileTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        this.gridId = id;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlot(new SlotUnitCraftingGrid(this.table, this.page, id++, this.x + 5 + x * 18, this.y + 5 + y * 18, this));
            }
        }
        for (int i = 0; i < 6; ++i) {
            this.addSlot(new SlotUnitCraftingStorage(this.table, this.page, id++, this.x + 5 + i * 18, this.y + 65, this));
        }
        this.resultId = id;
        this.addSlot(new SlotUnitCraftingResult(this.table, this.page, id++, this.x + 5 + 94, this.y + 5 + 18, this));
        this.outputId = id;
        this.addSlot(new SlotUnitCraftingOutput(this.table, this.page, id++, this.x + 5 + 94, this.y + 5 + 36, this));
        return id;
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return item != null && Upgrade.ParentType.CRAFTING.isValidParent(item);
    }

    @Override
    protected boolean canCharge() {
        return super.canCharge() && this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER);
    }

    public void onCrafting(EntityPlayer player, ItemStack item) {
        this.onCrafted(player, item);
        this.lockedRecipeGeneration = true;
        try {
            this.onCrafting(this.inventoryCrafting, player == null, false);
        }
        finally {
            this.lockedRecipeGeneration = false;
        }
        this.onGridChanged();
    }

    private void onCrafted(EntityPlayer player, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        try {
            item.func_77622_d(itemStack, this.table.func_145831_w(), player);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (player != null) {
            if (item == Item.func_150898_a((Block)Blocks.field_150462_ai)) {
                player.func_71064_a((StatBase)AchievementList.field_187984_h, 1);
            } else if (item instanceof ItemPickaxe) {
                player.func_71064_a((StatBase)AchievementList.field_187985_i, 1);
                if (((ItemPickaxe)item).func_150913_i() != Item.ToolMaterial.WOOD) {
                    player.func_71064_a((StatBase)AchievementList.field_187989_o, 1);
                }
            } else if (item == Item.func_150898_a((Block)Blocks.field_150460_al)) {
                player.func_71064_a((StatBase)AchievementList.field_187986_j, 1);
            } else if (item instanceof ItemHoe) {
                player.func_71064_a((StatBase)AchievementList.field_76013_l, 1);
            } else if (item == Items.field_151025_P) {
                player.func_71064_a((StatBase)AchievementList.field_187988_m, 1);
            } else if (item == Items.field_151105_aU) {
                player.func_71064_a((StatBase)AchievementList.field_76011_n, 1);
            } else if (item instanceof ItemSword) {
                player.func_71064_a((StatBase)AchievementList.field_187991_r, 1);
            } else if (item == Item.func_150898_a((Block)Blocks.field_150381_bn)) {
                player.func_71064_a((StatBase)AchievementList.field_187972_E, 1);
            } else if (item == Item.func_150898_a((Block)Blocks.field_150342_X)) {
                player.func_71064_a((StatBase)AchievementList.field_187974_G, 1);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        int index;
        super.draw(gui, mX, mY);
        boolean isEmpty = true;
        for (int i = this.gridId; i < this.gridId + 9; ++i) {
            if (this.table.func_70301_a(i) == null) continue;
            isEmpty = false;
            break;
        }
        int x = this.x + 5 + 54 + 3;
        int y = this.y + 5 + 0;
        if (isEmpty) {
            index = 0;
        } else if (gui.inBounds(x, y, 9, 9, mX, mY)) {
            index = 2;
            gui.drawMouseOver("Clear grid");
        } else {
            index = 1;
        }
        gui.drawRect(x, y, 48 + index * 9, 112, 9, 9);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
        super.onClick(gui, mX, mY);
        if (gui.inBounds(this.x + 5 + 54 + 3, this.y + 5 + 0, 9, 9, mX, mY)) {
            this.table.clearGridSend(this.id);
        }
    }

    private void onCrafting(CraftingBase crafting, boolean auto, boolean fake) {
        for (int i = 0; i < 9; ++i) {
            ItemStack containerItem;
            int j;
            ItemStack itemStack = crafting.func_70301_a(i);
            if (itemStack == null) continue;
            int id = i;
            int n = j = auto ? 0 : 9;
            while (j < crafting.getFullSize()) {
                ItemStack other;
                if (i != j && (other = crafting.func_70301_a(j)) != null && (j >= 9 || other.field_77994_a > itemStack.field_77994_a) && itemStack.func_77969_a(other) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)other)) {
                    id = j;
                    itemStack = other;
                    break;
                }
                ++j;
            }
            crafting.func_70298_a(id, 1);
            if (!itemStack.func_77973_b().hasContainerItem(itemStack) || (containerItem = itemStack.func_77973_b().getContainerItem(itemStack)).func_77984_f() && containerItem.func_77952_i() > containerItem.func_77958_k()) continue;
            crafting.func_70299_a(id, containerItem);
        }
    }

    public int getGridId() {
        return this.gridId;
    }

    public void onGridChanged() {
        if (!this.lockedRecipeGeneration) {
            IRecipe recipe = this.inventoryCrafting.getRecipe();
            ItemStack result = this.inventoryCrafting.getResult(recipe);
            if (result != null) {
                result = result.func_77946_l();
            }
            this.table.func_70299_a(this.resultId, result);
            if (this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER)) {
                if (recipe == null) {
                    this.canAutoCraft = false;
                } else {
                    CraftingDummy dummy = new CraftingDummy(this.inventoryCrafting);
                    this.onCrafting(dummy, true, true);
                    this.canAutoCraft = dummy.isMatch(recipe);
                }
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (++this.canCraftTick == 10) {
            this.canCraftTick = 0;
            if (this.oldGrid == null || !this.oldGrid.equals((Object)this.inventoryCrafting)) {
                this.oldGrid = new CraftingDummy(this.inventoryCrafting);
                this.onGridChanged();
            }
        }
    }

    public void onUpgradeChange() {
        if (this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.COMPACTOR) > 0 && this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.AUTO_CRAFTER) > 0) {
            for (int i = 0; i < 9; ++i) {
                this.table.getSlots().get(i + this.gridId).setEnabled(false);
            }
            this.table.getSlots().get(this.gridId + 4).setEnabled(true);
        } else {
            for (int i = 0; i < 9; ++i) {
                this.table.getSlots().get(i + this.gridId).setEnabled(true);
            }
        }
        this.onGridChanged();
    }

    @Override
    protected int getArrowX() {
        return 66;
    }

    @Override
    protected int getArrowY() {
        int offset = 0;
        if (this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER)) {
            offset = -5;
        }
        return 24 + offset;
    }

    @Override
    protected ItemStack getProductionResult() {
        ItemStack result;
        if (this.table.getUpgradePage().hasUpgrade(this.id, Upgrade.AUTO_CRAFTER) && (result = this.table.func_70301_a(this.resultId)) != null && this.canAutoCraft) {
            return result;
        }
        return null;
    }

    @Override
    protected int getOutputId() {
        return this.outputId;
    }

    @Override
    protected void onProduction(ItemStack result) {
        this.onCrafting(null, result);
    }

    private static class RepairRecipe
    implements IRecipe {
        private RepairRecipe() {
        }

        public boolean func_77569_a(InventoryCrafting crafting, World world) {
            return this.func_77572_b(crafting) != null;
        }

        public ItemStack func_77572_b(InventoryCrafting crafting) {
            Item repairItem = null;
            int count = 0;
            int units = 0;
            for (int i = 0; i < crafting.func_70302_i_(); ++i) {
                ItemStack item = crafting.func_70301_a(i);
                if (item == null) continue;
                if (repairItem == null) {
                    repairItem = item.func_77973_b();
                    if (!repairItem.isRepairable()) {
                        return null;
                    }
                    units = repairItem.func_77612_l() * 5 / 100;
                } else if (repairItem != item.func_77973_b() || item.field_77994_a != 1 || count == 2) {
                    return null;
                }
                units += item.func_77958_k() - item.func_77952_i();
                ++count;
            }
            if (repairItem != null && count == 2) {
                int damage = repairItem.func_77612_l() - units;
                if (damage < 0) {
                    damage = 0;
                }
                return new ItemStack(repairItem, 1, damage);
            }
            return null;
        }

        public int func_77570_a() {
            return 9;
        }

        public ItemStack func_77571_b() {
            return null;
        }

        public ItemStack[] func_179532_b(InventoryCrafting inv) {
            return null;
        }
    }

    private class CraftingBase
    extends InventoryCrafting {
        private static final int INVENTORY_WIDTH = 3;
        private static final int INVENTORY_HEIGHT = 3;

        public CraftingBase() {
            super(null, 3, 3);
        }

        public final int func_70302_i_() {
            return 9;
        }

        protected int getFullSize() {
            return 9 + (UnitCraft.this.table.getUpgradePage().hasUpgrade(UnitCraft.this.id, Upgrade.STORAGE) ? 6 : 0);
        }

        public ItemStack func_70298_a(int id, int count) {
            ItemStack item = this.func_70301_a(id);
            if (item != null) {
                if (item.field_77994_a <= count) {
                    this.func_70299_a(id, null);
                    return item;
                }
                ItemStack result = item.func_77979_a(count);
                if (item.field_77994_a == 0) {
                    this.func_70299_a(id, null);
                }
                return result;
            }
            return null;
        }

        public ItemStack func_70463_b(int x, int y) {
            if (x >= 0 && x < 3) {
                int id = x + y * 3;
                return this.func_70301_a(id);
            }
            return null;
        }

        public ItemStack getResult(IRecipe recipe) {
            return recipe == null ? null : recipe.func_77572_b((InventoryCrafting)this);
        }

        public boolean isMatch(IRecipe recipe) {
            return recipe.func_77569_a((InventoryCrafting)this, UnitCraft.this.table.func_145831_w());
        }

        public IRecipe getRecipe() {
            if (this.isMatch(REPAIR_RECIPE)) {
                return REPAIR_RECIPE;
            }
            for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
                IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
                if (!this.isMatch(recipe)) continue;
                return recipe;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CraftingBase)) {
                return false;
            }
            CraftingBase crafting = (CraftingBase)((Object)obj);
            if (this.getFullSize() != crafting.getFullSize()) {
                return false;
            }
            for (int i = 0; i < this.getFullSize(); ++i) {
                if (ItemStack.func_77989_b((ItemStack)this.func_70301_a(i), (ItemStack)crafting.func_70301_a(i))) continue;
                return false;
            }
            return true;
        }
    }

    private class CraftingDummy
    extends CraftingBase {
        private ItemStack[] items;

        private CraftingDummy(CraftingBase base) {
            this.items = new ItemStack[base.getFullSize()];
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack itemStack = base.func_70301_a(i);
                if (itemStack == null) continue;
                this.items[i] = itemStack.func_77946_l();
            }
        }

        @Override
        public int getFullSize() {
            return this.items.length;
        }

        public ItemStack func_70301_a(int id) {
            return this.items[id];
        }

        public void func_70299_a(int id, ItemStack item) {
            this.items[id] = item;
        }
    }

    private class CraftingWrapper
    extends CraftingBase {
        private CraftingWrapper() {
        }

        public ItemStack func_70301_a(int id) {
            return UnitCraft.this.table.func_70301_a(UnitCraft.this.gridId + id);
        }

        public void func_70299_a(int id, ItemStack item) {
            UnitCraft.this.table.func_70299_a(UnitCraft.this.gridId + id, item);
        }
    }
}

