/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.component;

import engineers.workshop.client.GuiBase;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextBox {
    private static final int SRC_X = 68;
    private static final int SRC_Y = 98;
    private static final int WIDTH = 82;
    private static final int HEIGHT = 12;
    private static final float MULTIPLIER = 0.7f;
    private static final int TEXT_X = 3;
    private static final int TEXT_Y = 5;
    private int x;
    private int y;
    private String text;
    private int cursor;
    private boolean updatedCursor = true;
    private int cursorPosition;

    public TextBox(int x, int y) {
        this.x = x;
        this.y = y;
        this.text = "";
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        if (this.isVisible()) {
            gui.prepare();
            gui.drawRect(this.x, this.y, 68, 98, 82, 12);
            gui.drawString(this.text, this.x + 3, this.y + 5, 0.7f, 0x1E1E1E);
            gui.drawCursor(this.x + this.getCursorPosition(gui) + 2, this.y + 1, 10, 1.0f, -7303024);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addText(GuiBase gui, String str) {
        String newText = this.text.substring(0, this.cursor) + str + this.text.substring(this.cursor);
        if ((float)gui.getStringWidth(newText) * 0.7f <= 82.0f) {
            this.text = newText;
            this.moveCursor(gui, str.length());
            this.textChanged();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void deleteText(GuiBase gui, int direction) {
        if (this.cursor + direction >= 0 && this.cursor + direction <= this.text.length()) {
            if (direction > 0) {
                this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
            } else {
                this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                this.moveCursor(gui, direction);
            }
            this.textChanged();
        }
    }

    protected void textChanged() {
    }

    @SideOnly(value=Side.CLIENT)
    private void moveCursor(GuiBase gui, int steps) {
        this.cursor += steps;
        this.updateCursor();
    }

    @SideOnly(value=Side.CLIENT)
    public void onKeyStroke(GuiBase gui, char c, int k) {
        if (this.isVisible()) {
            if (k == 203) {
                this.moveCursor(gui, -1);
            } else if (k == 205) {
                this.moveCursor(gui, 1);
            } else if (k == 14) {
                this.deleteText(gui, -1);
            } else if (k == 211) {
                this.deleteText(gui, 1);
            } else if (ChatAllowedCharacters.func_71566_a((char)c)) {
                this.addText(gui, Character.toString(c));
            }
        }
    }

    public void updateCursor() {
        if (this.cursor < 0) {
            this.cursor = 0;
        } else if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        this.updatedCursor = true;
    }

    public int getCursorPosition(GuiBase gui) {
        if (this.updatedCursor) {
            this.cursorPosition = (int)((float)gui.getStringWidth(this.text.substring(0, this.cursor)) * 0.7f);
            this.updatedCursor = false;
        }
        return this.cursorPosition;
    }

    public String getText() {
        return this.text;
    }

    public boolean isVisible() {
        return true;
    }
}

