/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.loot;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mal.lootbags.Bag;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.loot.LootItem;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryItemAccess;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class LootMap {
    private HashMap<String, LootItem> generalMap;
    private ArrayList<ResourceLocation> generalLootSources;
    private ArrayList<String> generalModBlacklist;
    private ArrayList<LootItem> generalBlacklist;
    private ArrayList<LootItem> generalWhitelist;
    public HashMap<String, LootItem> totalList;
    public ArrayList<LootItem> recyclerBlacklist;
    public ArrayList<LootItem> recyclerWhitelist;
    private LootContext context;
    private int generalTotalWeight;

    public LootMap() {
        this.clearMapData();
    }

    public void clearMapData() {
        this.generalMap = new HashMap();
        this.generalLootSources = new ArrayList();
        this.generalModBlacklist = new ArrayList();
        this.generalBlacklist = new ArrayList();
        this.generalWhitelist = new ArrayList();
        this.recyclerBlacklist = new ArrayList();
        this.recyclerWhitelist = new ArrayList();
        this.totalList = new HashMap();
        this.generalTotalWeight = 0;
    }

    public void populateRecyclerBlacklist(ArrayList<String> configRecyclerBlacklist) {
        for (String s : configRecyclerBlacklist) {
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 3) {
                try {
                    String modid = tempwords[0];
                    String itemname = tempwords[1];
                    ArrayList<Integer> itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(null, modid, itemname, dam, 1, 1, 1, false);
                        this.recyclerBlacklist.add(item);
                        LootbagsUtil.LogInfo("Added General Recycler Blacklist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Recycler Blacklist Error: Line: " + s + " Improperly formed Blacklisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Recycler Blacklist Error: Line: " + s + " Improperly formed Blacklisted item.");
        }
        for (Bag b : BagHandler.getBagList().values()) {
            if (!b.getRecyclerBlacklist()) continue;
            for (LootItem item : b.getMap().values()) {
                if (this.recyclerBlacklist.contains(item)) continue;
                this.recyclerBlacklist.add(item);
            }
        }
    }

    public void populateRecyclerWhitelist(ArrayList<String> configRecyclerWhitelist) {
        for (String s : configRecyclerWhitelist) {
            int weight;
            ArrayList<Integer> itemdamage;
            String itemname;
            String modid;
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 4) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    weight = Integer.parseInt(tempwords[3]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(null, modid, itemname, dam, 1, 1, weight, false);
                        this.recyclerWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Recycler Whitelist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Recycler Whitelist Error: Line: " + s + " Improperly formed Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            if (tempwords.length == 5) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    weight = Integer.parseInt(tempwords[3]);
                    byte[] nbt = LootbagsUtil.parseNBTArray(tempwords[4]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(null, modid, itemname, dam, 1, 1, weight, nbt, false);
                        this.generalWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Recycler Whitelist Item with NBT: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Recycler Whitelist Error: Line: " + s + " Improperly formed NBT Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Recycler Whitelist Error: Line: " + s + " Improperly formed Whitelisted item.");
        }
    }

    public void populateGeneralBlacklist(ArrayList<String> configBlacklist) {
        for (String s : configBlacklist) {
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 1) {
                if (this.generalModBlacklist.contains(tempwords[0])) continue;
                this.generalModBlacklist.add(tempwords[0]);
                continue;
            }
            if (tempwords.length == 3) {
                try {
                    String modid = tempwords[0];
                    String itemname = tempwords[1];
                    ArrayList<Integer> itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(null, modid, itemname, dam, 1, 1, 1, false);
                        this.generalBlacklist.add(item);
                        LootbagsUtil.LogInfo("Added General Blacklist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Blacklist Error: Line: " + s + " Improperly formed Blacklisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Blacklist Error: Line: " + s + " Improperly formed Blacklisted item.");
        }
    }

    public void populateGeneralWhitelist(ArrayList<String> configWhitelist) {
        for (String s : configWhitelist) {
            int weight;
            int maxstack;
            int minstack;
            ArrayList<Integer> itemdamage;
            String itemname;
            String modid;
            String trim = s.trim();
            if (trim.isEmpty()) continue;
            String[] tempwords = trim.split("(?<!$):");
            if (tempwords.length == 6) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    minstack = Integer.parseInt(tempwords[3]);
                    maxstack = Integer.parseInt(tempwords[4]);
                    weight = Integer.parseInt(tempwords[5]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(null, modid, itemname, dam, minstack, maxstack, weight, false);
                        this.generalWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Whitelist Item: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Whitelist Error: Line: " + s + " Improperly formed Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            if (tempwords.length == 7) {
                try {
                    modid = tempwords[0];
                    itemname = tempwords[1];
                    itemdamage = LootbagsUtil.constructDamageRange(tempwords[2]);
                    minstack = Integer.parseInt(tempwords[3]);
                    maxstack = Integer.parseInt(tempwords[4]);
                    weight = Integer.parseInt(tempwords[5]);
                    byte[] nbt = LootbagsUtil.parseNBTArray(tempwords[6]);
                    for (Integer dam : itemdamage) {
                        LootItem item = new LootItem(null, modid, itemname, dam, minstack, maxstack, weight, nbt, false);
                        this.generalWhitelist.add(item);
                        LootbagsUtil.LogInfo("Added General Whitelist Item with NBT: " + item.toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    LootbagsUtil.LogError("General Whitelist Error: Line: " + s + " Improperly formed NBT Whitelisted item causing exception.");
                    e.printStackTrace();
                    continue;
                }
            }
            LootbagsUtil.LogError("General Whitelist Error: Line: " + s + " Improperly formed Whitelisted item.");
        }
    }

    public void populateGeneralMap(World world) {
        for (ResourceLocation source : this.generalLootSources) {
            try {
                this.addLootCategory(source, world);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        for (LootItem item : this.generalWhitelist) {
            if (item.getContentItem() == null) {
                item.reinitializeLootItem();
            }
            if (item.getContentItem() == null) {
                LootbagsUtil.LogError("Loot Item with information: " + item.getItemModID() + ":" + item.getItemName() + " does not exist, even after reinitilizing it. This typically means the whitelist entry is wrong. This item will be skipped.");
                continue;
            }
            String key = item.getItemModID() + item.getItemName() + item.getContentItem().func_77952_i();
            if (item.getContentItem().func_77973_b() instanceof ItemEnchantedBook && item.getContentItem().func_77942_o()) {
                key = key + item.getContentItem().func_77978_p().toString();
            }
            if (this.generalMap.containsKey(key)) {
                this.generalMap.remove(key);
            }
            this.generalMap.put(key, item);
            if (this.totalList.containsKey(key)) continue;
            this.totalList.put(key, item);
        }
    }

    public void addLootCategory(ResourceLocation categoryName, World world) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String entryname;
        String poolname;
        LootbagsUtil.LogInfo("Starting adding items from loot table: " + categoryName + ".");
        LootTable table = LootbagsUtil.getLootManager(world).func_186521_a(categoryName);
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            poolname = "pools";
            entryname = "lootEntries";
        } else {
            poolname = "field_186466_c";
            entryname = "field_186453_a";
        }
        Field poolListField = LootTable.class.getDeclaredField(poolname);
        poolListField.setAccessible(true);
        Field lootListField = LootPool.class.getDeclaredField(entryname);
        lootListField.setAccessible(true);
        this.processLootTable(table, 0, poolListField, lootListField);
    }

    private void processLootTable(LootTable table, int count, Field poolListField, Field lootListField) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (count > 10) {
            return;
        }
        List poolList = (List)poolListField.get(table);
        for (LootPool pool : poolList) {
            List lootList = (List)lootListField.get(pool);
            for (LootEntry loot : lootList) {
                if (loot instanceof LootEntryItem) {
                    int maxstack;
                    int minstack;
                    LootEntryItem lloot = (LootEntryItem)loot;
                    ItemStack stack = LootEntryItemAccess.getLootEntryItemStack(lloot);
                    int weight = LootEntryItemAccess.getLootEntryItemWeight((LootEntry)lloot);
                    RandomValueRange range = LootEntryItemAccess.getStackSizes(lloot);
                    if (range != null) {
                        minstack = (int)range.func_186509_a();
                        maxstack = (int)range.func_186512_b();
                    } else {
                        minstack = 1;
                        maxstack = 1;
                    }
                    LootItem item = null;
                    boolean skip = false;
                    if (stack == null || stack.func_77973_b() == null) {
                        skip = true;
                        LootbagsUtil.LogInfo("Found a null item in the loot table, skipping it.");
                    } else {
                        item = new LootItem(lloot, stack, minstack, maxstack, weight, true);
                    }
                    if (item != null && item.getItemWeight() < 1) {
                        LootbagsUtil.LogError("Item " + item.getContentItem().toString() + " has a weighting of " + item.getItemWeight() + ".  This is not a Lootbags error but an error in a different mod!  This item will be excluded from the Lootbags loot table.");
                    } else if (!skip) {
                        for (String modid : this.generalModBlacklist) {
                            if (!ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.getContentItem().func_77973_b()).func_110624_b().equalsIgnoreCase(modid)) continue;
                            skip = true;
                            LootbagsUtil.LogInfo("Found item to skip from Blacklisted mod: " + item.toString());
                        }
                        for (LootItem entry : this.generalBlacklist) {
                            String name = entry.getItemName();
                            if (!ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.getContentItem().func_77973_b()).func_110623_a().equalsIgnoreCase(name)) continue;
                            skip = true;
                            LootbagsUtil.LogInfo("Found Blacklisted item to skip: " + item.toString());
                        }
                        if (!skip) {
                            String key = item.getItemModID() + item.getItemName() + item.getContentItem().func_77952_i();
                            if (!this.generalMap.containsKey(key)) {
                                this.generalMap.put(key, item);
                                LootbagsUtil.LogDebug("Added new General Item: " + item.toString());
                                if (!this.totalList.containsKey(key)) {
                                    this.totalList.put(key, item);
                                }
                            } else {
                                LootItem it = this.generalMap.get(key);
                                int wweight = it.getItemWeight();
                                wweight = (wweight + item.getItemWeight()) / 2;
                                it.setItemWeight(wweight);
                                this.generalMap.put(key, it);
                                LootbagsUtil.LogDebug("Merged new General Item: " + item.toString());
                                if (!this.totalList.containsKey(key)) {
                                    this.totalList.put(key, it);
                                }
                            }
                        }
                    }
                }
                if (!(loot instanceof LootEntryTable)) continue;
                LootEntryTable tloot = (LootEntryTable)loot;
                LootTable ltable = LootEntryItemAccess.getLootTable(tloot, this.context);
                this.processLootTable(ltable, count + 1, poolListField, lootListField);
            }
        }
    }

    public ArrayList<LootItem> getMapByWeight(int minWeight, int maxWeight) {
        ArrayList<LootItem> ret = new ArrayList<LootItem>();
        for (LootItem item : this.generalMap.values()) {
            if (minWeight != -1 && item.getItemWeight() < minWeight || maxWeight != -1 && item.getItemWeight() > maxWeight) continue;
            ret.add(item);
        }
        Collections.sort(ret);
        return ret;
    }

    public HashMap<String, LootItem> getMap() {
        return this.generalMap;
    }

    public void setTotalListWeight() {
        this.generalTotalWeight = 0;
        for (LootItem item : this.totalList.values()) {
            this.generalTotalWeight += item.getItemWeight();
        }
        for (LootItem item : this.recyclerWhitelist) {
            this.generalTotalWeight += item.getItemWeight();
        }
    }

    public int getTotalListWeight() {
        return this.generalTotalWeight;
    }

    public void setLootSources(String[] sources) {
        for (int i = 0; i < sources.length; ++i) {
            this.generalLootSources.add(new ResourceLocation(sources[i]));
        }
    }

    public LootContext getContext() {
        return this.context;
    }

    public void setContext(@Nullable WorldServer world) {
        this.context = new LootContext(0.0f, world, LootbagsUtil.getLootManager((World)world), null, null, null);
    }
}

