/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.jei;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mal.lootbags.Bag;
import mal.lootbags.loot.LootItem;
import net.minecraft.item.ItemStack;

public class LootEntry {
    private Set<LootItem> drops = new HashSet<LootItem>();
    private Bag bag;
    private String bagName;

    public LootEntry(Bag bag) {
        this.bag = bag;
        this.bagName = bag.getBagName();
        for (LootItem item : bag.getMap().values()) {
            this.drops.add(item);
        }
    }

    public String getName() {
        return this.bagName;
    }

    public boolean containsItem(ItemStack item) {
        return this.drops.stream().anyMatch(drop -> drop.getContentItem().func_77969_a(item));
    }

    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (LootItem item : this.drops) {
            list.add(item.getContentItem());
        }
        return list;
    }

    public LootItem getBagDrop(ItemStack item) {
        return this.drops.stream().filter(drop -> ItemStack.func_179545_c((ItemStack)drop.getContentItem(), (ItemStack)item)).findFirst().orElse(null);
    }

    public Bag getBag() {
        return this.bag;
    }

    public Object[] getInput() {
        return new Object[]{this.bag.getBagItem()};
    }
}

