/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.config.BagEntitySource;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.loot.LootItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Bag {
    private String bagName = "Default";
    private String bagNameColor = "";
    private int bagIndex = -1;
    private List<String> bagTextUnopened = new ArrayList<String>();
    private List<String> bagTextOpened = new ArrayList<String>();
    private List<String> bagTextShift = new ArrayList<String>();
    private int bagTextureColorBase = 0xFFFFFF;
    private int bagTextureColorString = 0xFFFFFF;
    private boolean useAltJsonFile = true;
    private int bagWeight = LootBags.getDefaultDropWeight();
    private int craftCount = -1;
    private int[] spawnChances = new int[4];
    private int maxItems = 5;
    private int minItems = 1;
    private int maxGeneralWeight = -1;
    private int minGeneralWeight = -1;
    private boolean entityExclusionToggle = false;
    private boolean useGeneralLootTable = false;
    private boolean isSecret = false;
    private boolean recyclerBlacklist = false;
    private int preventItemRepeats = 0;
    private int bagMapWeight = 0;
    private boolean bagIsEmpty = false;
    private String sourceBagName = null;
    private HashMap<String, LootItem> map = new HashMap();
    private ArrayList<LootItem> BagWhitelist = new ArrayList();
    private ArrayList<LootItem> BagBlacklist = new ArrayList();
    private ArrayList<String> BagModBlacklist = new ArrayList();
    private ArrayList<BagEntitySource> EntityList = new ArrayList();

    public Bag(String name, int index) {
        this.bagName = name;
        this.bagIndex = index;
    }

    /*
     * WARNING - void declaration
     */
    public void populateBag() {
        String key;
        ArrayList<Object> list = this.useGeneralLootTable ? LootBags.LOOTMAP.getMapByWeight(this.minGeneralWeight, this.maxGeneralWeight) : new ArrayList();
        ArrayList<LootItem> nullClear = new ArrayList<LootItem>();
        for (LootItem lootItem : this.BagBlacklist) {
            if (lootItem.getContentItem() == null) {
                lootItem.reinitializeLootItem();
            }
            if (lootItem.getContentItem() != null) continue;
            LootbagsUtil.LogError("Blacklisted Content Item " + lootItem.getItemModID() + ":" + lootItem.getItemName() + " is NULL.  This is a major problem, probably caused by the item not being initilized and added to the Forge registry before the ServerStarted event when this code runs.");
            nullClear.add(lootItem);
        }
        this.BagBlacklist.removeAll(nullClear);
        for (LootItem lootItem : list) {
            if (LootbagsUtil.listContainsItem(this.BagBlacklist, lootItem) || this.BagModBlacklist.contains(lootItem.getItemModID())) continue;
            key = lootItem.getItemModID() + lootItem.getItemName() + lootItem.getContentItem().func_77952_i();
            this.map.put(key, lootItem);
        }
        for (LootItem lootItem : this.BagWhitelist) {
            if (lootItem.getContentItem() == null) {
                lootItem.reinitializeLootItem();
            }
            if (lootItem.getContentItem() != null) {
                key = lootItem.getItemModID() + lootItem.getItemName() + lootItem.getContentItem().func_77952_i();
                if (lootItem.getContentItem().func_77942_o()) {
                    key = key + lootItem.getContentItem().func_77978_p().toString();
                }
                if (this.getItemRepeats() == 3) {
                    key = key + this.BagWhitelist.indexOf(lootItem);
                }
                if (this.map.containsKey(key)) {
                    this.map.remove(key);
                }
                this.map.put(key, lootItem);
                if (LootBags.LOOTMAP.totalList.containsKey(key)) continue;
                LootBags.LOOTMAP.totalList.put(key, lootItem);
                continue;
            }
            LootbagsUtil.LogError("Whitelisted Content Item " + lootItem.getItemModID() + ":" + lootItem.getItemName() + " is NULL.  This is a major problem, probably caused by the item not being initilized and added to the Forge registry before the PostInit event when this code runs.");
        }
        int average = 0;
        boolean bl = false;
        for (LootItem item : this.map.values()) {
            void var4_11;
            if (item.getItemWeight() > average * 10 && average > 0) {
                item.setItemWeight(average * 10);
            }
            this.bagMapWeight += item.getItemWeight();
            average = this.bagMapWeight / ++var4_11;
        }
        if (this.bagMapWeight <= 0) {
            this.bagIsEmpty = true;
        }
        if (LootBags.DEBUGMODE) {
            LootbagsUtil.LogDebug("Bag ID: " + this.bagIndex);
            LootbagsUtil.LogDebug("Bag Weight: " + this.bagMapWeight);
            for (LootItem item : this.map.values()) {
                LootbagsUtil.LogDebug(item.toString());
            }
        }
    }

    public ItemStack getRandomItem() {
        ArrayList<LootItem> content = BagHandler.generateContent(this.map.values());
        if (content.size() > 0 && this.bagMapWeight > 0) {
            LootItem item = LootbagsUtil.getRandomItem(content, this.bagMapWeight);
            for (int r = 0; item == null && r < LootBags.MAXREROLLCOUNT; ++r) {
                LootbagsUtil.LogInfo("Rerolling null item: Reroll count " + r + ".");
                item = LootbagsUtil.getRandomItem(content, this.bagMapWeight);
            }
            if (item == null) {
                return null;
            }
            ItemStack[] stacks = LootbagsUtil.generateStacks(LootBags.getRandom(), item, item.getMinStack(), item.getMaxStack());
            return stacks.length > 0 ? stacks[0] : null;
        }
        LootbagsUtil.LogError("Failed to get random item: Bag loot table or total weight <= 0.  This probably means this bag's config information is messed up somehow.");
        return null;
    }

    public ItemStack getSpecificItem(int index) {
        if (index < this.map.values().size()) {
            return ((LootItem)this.map.values().toArray()[index]).getContentItem();
        }
        return null;
    }

    public void addWhitelistItem(LootItem item) {
        this.BagWhitelist.add(item);
    }

    public void addWhitelistItem(String modid, String itemname, ArrayList<Integer> damage, int minstack, int maxstack, int weight) {
        for (Integer dam : damage) {
            LootItem item = new LootItem(null, modid, itemname, dam, minstack, maxstack, weight, false);
            this.BagWhitelist.add(item);
        }
    }

    public void addWhitelistItem(String modid, String itemname, ArrayList<Integer> damage, int minstack, int maxstack, int weight, byte[] nbt) {
        for (Integer dam : damage) {
            LootItem item = new LootItem(null, modid, itemname, dam, minstack, maxstack, weight, nbt, false);
            this.BagWhitelist.add(item);
        }
    }

    public void addBlacklistItem(LootItem item) {
        this.BagBlacklist.add(item);
    }

    public void addBlacklistItem(String modid, String itemname, ArrayList<Integer> damage) {
        for (Integer dam : damage) {
            LootItem item = new LootItem(null, modid, itemname, dam, 1, 1, 1, false);
            this.BagBlacklist.add(item);
        }
    }

    public void addBlacklistItem(String modid) {
        if (!this.BagModBlacklist.contains(modid)) {
            this.BagModBlacklist.add(modid);
        }
    }

    public void setWeight(int weight) {
        this.bagWeight = weight;
    }

    public void setSpawnChancePlayer(int spawnchance) {
        this.spawnChances[0] = spawnchance;
    }

    public void setSpawnChancePassive(int spawnchance) {
        this.spawnChances[1] = spawnchance;
    }

    public void setSpawnChanceMonster(int spawnchance) {
        this.spawnChances[2] = spawnchance;
    }

    public void setSpawnChanceBoss(int spawnchance) {
        this.spawnChances[3] = spawnchance;
    }

    public void setCraftingSource(String bagName, int count) {
        this.sourceBagName = bagName;
        this.craftCount = count;
    }

    public void setBagNameColor(String code) {
        this.bagNameColor = code;
    }

    public void addUnopenedText(String text) {
        if (this.bagTextUnopened == null) {
            this.bagTextUnopened = new ArrayList<String>();
        }
        this.bagTextUnopened.add(text);
    }

    public void addOpenedText(String text) {
        if (this.bagTextOpened == null) {
            this.bagTextOpened = new ArrayList<String>();
        }
        text = text.replace("$", "");
        this.bagTextOpened.add(text);
    }

    public void addShiftText(String text) {
        if (this.bagTextShift == null) {
            this.bagTextShift = new ArrayList<String>();
        }
        text = text.replace("$", "");
        this.bagTextShift.add(text);
    }

    public void setBagColor(int baseColor, int stringColor) {
        this.bagTextureColorBase = baseColor;
        this.bagTextureColorString = stringColor;
        this.useAltJsonFile = false;
    }

    public String getBagName() {
        return this.bagName;
    }

    public String getBagNameColor() {
        return this.bagNameColor;
    }

    public String getDefaultName() {
        return "lootbag";
    }

    public int[] getChances() {
        return this.spawnChances;
    }

    public String getCraftingSource() {
        return this.sourceBagName;
    }

    public int getCraftingCount() {
        return this.craftCount;
    }

    public boolean isBagEmpty() {
        return this.bagIsEmpty;
    }

    public String getMonsterDropChance() {
        float chance = (float)this.spawnChances[2] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public String getPassiveDropChance() {
        float chance = (float)this.spawnChances[1] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public String getPlayerDropChance() {
        float chance = (float)this.spawnChances[0] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public String getBossDropChance() {
        float chance = (float)this.spawnChances[3] * 100.0f / (float)LootBags.DROPRESOLUTION;
        return String.format("%.2f", Float.valueOf(chance));
    }

    public int getBossDropWeight() {
        return this.spawnChances[3];
    }

    public int getPlayerDropWeight() {
        return this.spawnChances[0];
    }

    public int getPassiveDropWeight() {
        return this.spawnChances[1];
    }

    public int getMonsterDropWeight() {
        return this.spawnChances[2];
    }

    public ItemStack getBagItem() {
        return new ItemStack((Item)LootBags.lootbagItem, 1, this.bagIndex);
    }

    public Bag setSecret(boolean secret) {
        this.isSecret = secret;
        return this;
    }

    public void setGeneralSources(boolean state) {
        this.useGeneralLootTable = state;
    }

    public boolean getSecret() {
        return this.isSecret;
    }

    public int getBagIndex() {
        return this.bagIndex;
    }

    public List<String> getBagTextUnopened() {
        return this.bagTextUnopened;
    }

    public List<String> getBagTextOpened() {
        return this.bagTextOpened;
    }

    public List<String> getBagTextShift() {
        return this.bagTextShift;
    }

    public int[] getBagTextureColor() {
        int[] color = new int[]{this.bagTextureColorBase, this.bagTextureColorString};
        return color;
    }

    public boolean getUseAltJson() {
        return this.useAltJsonFile;
    }

    public int getBagWeight() {
        return this.bagWeight;
    }

    public HashMap<String, LootItem> getMap() {
        return this.map;
    }

    private boolean addItemToMap(LootItem content) {
        String key = content.getItemModID() + content.getItemName() + content.getContentItem().func_77952_i();
        if (!this.map.containsKey(key)) {
            this.map.put(key, content);
            return true;
        }
        return false;
    }

    public void setMaximumItemsDropped(int weight) {
        this.maxItems = weight;
    }

    public void setMinimumItemsDropped(int weight) {
        this.minItems = weight;
    }

    public void setMaximumGeneralWeight(int weight) {
        this.maxGeneralWeight = weight;
    }

    public void setMinimumGeneralWeight(int weight) {
        this.minGeneralWeight = weight;
    }

    public void setItemRepeats(int state) {
        this.preventItemRepeats = state;
    }

    public void setEntityExclusion(boolean state) {
        this.entityExclusionToggle = state;
    }

    public boolean getEntityExlusion() {
        return this.entityExclusionToggle;
    }

    public void addEntityToList(String name, boolean isVisibleName) {
        BagEntitySource bs = new BagEntitySource(name, isVisibleName);
        this.EntityList.add(bs);
    }

    public ArrayList<BagEntitySource> getEntityList() {
        return this.EntityList;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public int getItemRepeats() {
        return this.preventItemRepeats;
    }

    public void setRecyclerBlacklist(boolean b) {
        this.recyclerBlacklist = b;
    }

    public boolean getRecyclerBlacklist() {
        return this.recyclerBlacklist;
    }
}

