/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model.parsing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.model.IModelParser;
import team.chisel.ctm.client.model.parsing.ModelParserV1;

public enum ModelLoaderCTM implements ICustomModelLoader
{
    INSTANCE;

    private static final Map<Integer, IModelParser> parserVersions;
    private IResourceManager manager;
    private Map<ResourceLocation, JsonElement> jsonCache = Maps.newHashMap();
    private Map<ResourceLocation, IModelCTM> loadedModels = Maps.newHashMap();
    private final Set<ResourceLocation> loading = new HashSet<ResourceLocation>();
    private ResourceLocation prev;
    public static final Set<ResourceLocation> parsedLocations;

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.jsonCache.clear();
        this.loadedModels.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (modelLocation instanceof ModelResourceLocation) {
            modelLocation = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        }
        if (this.loading.contains(modelLocation)) {
            return false;
        }
        JsonElement json = this.getJSON(modelLocation);
        return json.isJsonObject() && json.getAsJsonObject().has("ctm_version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        this.loading.add(modelLocation);
        try {
            this.loadedModels.computeIfAbsent(modelLocation, res -> this.loadFromFile((ResourceLocation)res, true));
            IModelCTM model = this.loadedModels.get(modelLocation);
            if (model != null) {
                model.load();
            }
            IModelCTM iModelCTM = model;
            return iModelCTM;
        }
        finally {
            this.loading.remove(modelLocation);
        }
    }

    @Nonnull
    public JsonElement getJSON(ResourceLocation modelLocation) {
        return this.jsonCache.computeIfAbsent(modelLocation, res -> {
            String path = modelLocation.func_110623_a() + ".json";
            if (!path.startsWith("models/")) {
                path = "models/" + path;
            }
            ResourceLocation absolute = new ResourceLocation(modelLocation.func_110624_b(), path);
            try {
                IResource resource = this.manager.func_110536_a(absolute);
                JsonElement ele = new JsonParser().parse((Reader)new InputStreamReader(resource.func_110527_b()));
                if (ele != null) {
                    return ele;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return JsonNull.INSTANCE;
        });
    }

    private IModelCTM loadFromFile(ResourceLocation res, boolean forLoad) {
        JsonObject json;
        IModelParser parser;
        if (forLoad) {
            parsedLocations.add(new ResourceLocation(res.func_110624_b(), res.func_110623_a().replace("models/", "")));
        }
        if ((parser = parserVersions.get((json = this.getJSON(res).getAsJsonObject()).get("ctm_version").getAsInt())) == null) {
            throw new IllegalArgumentException("Invalid \"ctm_version\" in model " + res);
        }
        return parser.fromJson(res, json);
    }

    static {
        parserVersions = ImmutableMap.of((Object)1, (Object)new ModelParserV1());
        parsedLocations = new HashSet<ResourceLocation>();
    }
}

