/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.net.packetAPI;

import com.mrdimka.hammercore.net.packetAPI.IPacket;
import com.mrdimka.hammercore.net.packetAPI.IPacketListener;
import com.mrdimka.hammercore.net.packetAPI.PacketManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCustomNBT
implements IMessage,
IMessageHandler<PacketCustomNBT, IMessage> {
    public NBTTagCompound nbt = new NBTTagCompound();

    PacketCustomNBT(IPacket packet, String channel) {
        NBTTagCompound nbt = new NBTTagCompound();
        packet.writeToNBT(nbt);
        this.nbt.func_74782_a("PacketData", (NBTBase)nbt);
        this.nbt.func_74778_a("PacketClass", packet.getClass().getName());
        this.nbt.func_74778_a("Channel", channel);
    }

    public PacketCustomNBT() {
    }

    public IMessage onMessage(PacketCustomNBT message, MessageContext ctx) {
        try {
            NBTTagCompound nbt = message.nbt;
            PacketManager mgr = PacketManager.getManagerByChannel(message.nbt.func_74779_i("Channel"));
            Class<?> packetClass = Class.forName(nbt.func_74779_i("PacketClass"));
            IPacket packet = (IPacket)packetClass.newInstance();
            IPacketListener listener = null;
            if (packet instanceof IPacketListener) {
                listener = (IPacketListener)((Object)packet);
            } else {
                mgr.stringClassRegistry.get(packetClass.getName());
            }
            packet.readFromNBT(nbt.func_74775_l("PacketData"));
            Object pkt = listener.onArrived(packet, ctx);
            if (pkt != null) {
                return new PacketCustomNBT((IPacket)pkt, nbt.func_74779_i("Channel"));
            }
        }
        catch (Throwable err) {
            System.out.println("Can't handle packet for class " + message.nbt.func_74779_i("PacketClass"));
            err.printStackTrace();
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }
}

