/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.gui;

import com.mrdimka.hammercore.client.UV;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.gui.GuiCentered;
import com.mrdimka.hammercore.math.ExpressionEvaluator;
import com.mrdimka.hammercore.math.functions.ExpressionFunction;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class GuiCalculator
extends GuiCentered {
    private Set<Btn> btns = new HashSet<Btn>();
    public static final UV bg = new UV(new ResourceLocation("hammercore", "textures/gui/gui_calculator.png"), 0.0, 0.0, 147.0, 147.0);
    private String expression = "";
    private int lastBtn = -1;
    private float closeMod = 0.0f;
    private float btnMod = 0.0f;

    public GuiCalculator() {
        this.btns.add(new Btn("Cl", 87, 60, this.btns.size(), 18, 14, () -> {
            this.expression = "";
        }));
        this.btns.add(new Btn(",", 116, 124, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + ".";
        }));
        this.btns.add(new Btn("0", 96, 124, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "0";
        }));
        this.btns.add(new Btn("1", 87, 108, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "1";
        }));
        this.btns.add(new Btn("2", 106, 108, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "2";
        }));
        this.btns.add(new Btn("3", 125, 108, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "3";
        }));
        this.btns.add(new Btn("4", 87, 92, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "4";
        }));
        this.btns.add(new Btn("5", 106, 92, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "5";
        }));
        this.btns.add(new Btn("6", 125, 92, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "6";
        }));
        this.btns.add(new Btn("7", 87, 76, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "7";
        }));
        this.btns.add(new Btn("8", 106, 76, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "8";
        }));
        this.btns.add(new Btn("9", 125, 76, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "9";
        }));
        this.btns.add(new Btn("\u221a", 14, 76, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "sqrt(";
        }));
        this.btns.add(new Btn("sin", 34, 76, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "sin(";
        }));
        this.btns.add(new Btn("cos", 14, 92, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "cos(";
        }));
        this.btns.add(new Btn("tan", 34, 92, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "tan(";
        }));
        this.btns.add(new Btn("log", 14, 108, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "log(";
        }));
        this.btns.add(new Btn("abs", 34, 108, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "abs(";
        }));
        this.btns.add(new Btn("\u1d28", 14, 124, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + '\u1d28';
        }));
        this.btns.add(new Btn("E", 34, 124, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "E";
        }));
        this.btns.add(new Btn("+", 54, 76, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "+";
        }));
        this.btns.add(new Btn("-", 54, 92, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "-";
        }));
        this.btns.add(new Btn("*", 54, 108, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "*";
        }));
        this.btns.add(new Btn("/", 54, 124, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "/";
        }));
        this.btns.add(new Btn("(", 24, 60, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + "(";
        }));
        this.btns.add(new Btn(")", 44, 60, this.btns.size(), 18, 14, () -> {
            this.expression = this.expression + ")";
        }));
        this.btns.add(new Btn("=", 75, 130, this.btns.size(), 18, 14, () -> {
            if (this.expression.isEmpty()) {
                return;
            }
            try {
                this.expression = ExpressionEvaluator.evaluate(this.expression, new ExpressionFunction[0]) + ";";
            }
            catch (Throwable err) {
                this.expression = "Error!";
            }
        }));
        this.xSize = 147.0;
        this.ySize = 147.0;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        bg.render(this.guiLeft, this.guiTop);
        this.closeMod = (double)mouseX >= this.guiLeft + 125.0 && (double)mouseY >= this.guiTop + 1.0 && (double)mouseX < this.guiLeft + 144.0 && (double)mouseY < this.guiTop + 14.0 ? (this.closeMod += (1.0f - this.closeMod) / 2.0f) : 0.0f;
        int btn = this.getButton(mouseX, mouseY);
        if (btn != this.lastBtn) {
            this.btnMod = 0.0f;
            this.lastBtn = btn;
        }
        this.btnMod = this.lastBtn != -1 ? (this.btnMod += (1.0f - this.btnMod) / 16.0f) : 0.0f;
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.btnMod);
        RenderUtil.drawTexturedModalRect(this.guiLeft + (double)this.getButtonX(this.lastBtn), this.guiTop + (double)this.getButtonY(this.lastBtn), 147.0, 13.0, 18.0, 14.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.closeMod);
        RenderUtil.drawTexturedModalRect(this.guiLeft + 125.0, this.guiTop + 1.0, 147.0, 0.0, 19.0, 13.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        for (Btn b : this.btns) {
            b.draw(this.field_146289_q, this.guiLeft + (double)b.x, this.guiTop + (double)b.y);
        }
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.hammercore:calculatron").replaceAll("vVERSION", "v1.9.4.3"), (float)((int)this.guiLeft + 14), (float)((int)this.guiTop + 4), 0xFFFFFF, false);
        String expression = this.expression;
        if (expression.endsWith(";")) {
            expression = expression.substring(0, expression.length() - 1);
        }
        GL11.glPushMatrix();
        double maxLen = 132.0;
        int w = this.field_146289_q.func_78256_a(expression);
        GL11.glTranslated((double)(this.guiLeft + 7.5), (double)(this.guiTop + 31.0 + 8.5 + ((double)w > maxLen ? 1.0 - maxLen / (double)w : 0.0)), (double)0.0);
        if (w > 133) {
            GL11.glScaled((double)(133.0 / (double)w), (double)(133.0 / (double)w), (double)1.0);
        }
        this.field_146289_q.func_175065_a(expression, 0.0f, 0.0f, 0, false);
        GL11.glPopMatrix();
    }

    private int getButton(int mouseX, int mouseY) {
        mouseX = (int)((double)mouseX - this.guiLeft);
        mouseY = (int)((double)mouseY - this.guiTop);
        for (Btn b : this.btns) {
            if (mouseX < b.x || mouseY < b.y || mouseX >= b.x + b.w || mouseY >= b.y + b.h) continue;
            return b.id;
        }
        return -1;
    }

    private int getButtonX(int btn) {
        for (Btn b : this.btns) {
            if (btn != b.id) continue;
            return b.x;
        }
        return 0;
    }

    private int getButtonY(int btn) {
        for (Btn b : this.btns) {
            if (btn != b.id) continue;
            return b.y;
        }
        return 0;
    }

    private void click(int btn) {
        for (Btn b : this.btns) {
            if (btn != b.id || b.onClick == null) continue;
            if (this.expression.equals("Error!") || this.expression.endsWith(";")) {
                this.expression = "";
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            b.onClick.run();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int btn = this.getButton(mouseX, mouseY);
        if (btn != -1) {
            this.click(btn);
        }
        if ((double)mouseX >= this.guiLeft + 125.0 && (double)mouseY >= this.guiTop + 1.0 && (double)mouseX < this.guiLeft + 144.0 && (double)mouseY < this.guiTop + 14.0) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    private static class Btn {
        private int x;
        private int y;
        private int id;
        private int w;
        private int h;
        private Runnable onClick;
        private String c;

        public Btn(String c, int x, int y, int id, int w, int h, Runnable onClick) {
            this.c = c;
            this.onClick = onClick;
            this.x = x;
            this.y = y;
            this.id = id;
            this.w = w;
            this.h = h;
        }

        public void draw(FontRenderer fr, double x, double y) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + (double)(this.w - fr.func_78256_a(this.c)) / 2.0), (double)(y + ((double)this.h - 6.5) / 2.0), (double)0.0);
            fr.func_175065_a(this.c, 0.0f, 0.0f, 0, false);
            GL11.glPopMatrix();
        }
    }
}

