/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.model;

import com.mrdimka.hammercore.client.model.CasedModel;
import com.mrdimka.hammercore.client.model.CasedModelLoader;
import com.mrdimka.hammercore.client.model.SimpleModelLoader;
import com.mrdimka.hammercore.client.model.file.ModelFile;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum HCModelRegistry {
    INSTANCE;

    public final Map<String, ModelBase> simpleModelCache = new HashMap<String, ModelBase>();
    public final Map<String, CasedModel> casedModelCache = new HashMap<String, CasedModel>();

    private HCModelRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ModelBase getModelByPath(ResourceLocation location) {
        return this.simpleModelCache.get(location + "");
    }

    public ModelBase getModelByPath(String path) {
        return this.simpleModelCache.get(path);
    }

    public CasedModel getCasedModelByPath(ResourceLocation location) {
        return this.casedModelCache.get(location + "");
    }

    public CasedModel getCasedModelByPath(String path) {
        return this.casedModelCache.get(path);
    }

    public void registerModel(String path) {
        this.simpleModelCache.put(path, null);
    }

    public void registerModel(ResourceLocation location) {
        this.simpleModelCache.put(location + "", null);
    }

    public void registerCasedModel(String path) {
        this.casedModelCache.put(path, null);
    }

    public void registerCasedModel(ResourceLocation location) {
        this.casedModelCache.put(location + "", null);
    }

    @SubscribeEvent
    public void reloadResources(TextureStitchEvent event) {
        this.reloadModels();
    }

    public void reloadModels() {
        String[] cache;
        IResourceManager mgr = Minecraft.func_71410_x().func_110442_L();
        int cycles = 0;
        while (true) {
            try {
                if (cycles++ >= 32) {
                    return;
                }
                cache = this.simpleModelCache.keySet().toArray(new String[0]);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
        for (String k : cache) {
            try {
                InputStream i = mgr.func_110536_a(new ResourceLocation(k)).func_110527_b();
                this.simpleModelCache.put(k, SimpleModelLoader.convert(ModelFile.read(i)));
            }
            catch (Throwable err) {
                FMLLog.info((String)("Model " + k + " could not be loaded:"), (Object[])new Object[0]);
                err.printStackTrace();
            }
        }
    }

    public void reloadCasedModels() {
        String[] cache;
        IResourceManager mgr = Minecraft.func_71410_x().func_110442_L();
        int cycles = 0;
        while (true) {
            try {
                if (cycles++ >= 32) {
                    return;
                }
                cache = this.casedModelCache.keySet().toArray(new String[0]);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
        for (String k : cache) {
            try {
                InputStream i = mgr.func_110536_a(new ResourceLocation(k)).func_110527_b();
                BufferedReader br = new BufferedReader(new InputStreamReader(i, "UTF-8"));
                String lns = "";
                String ln = br.readLine();
                while (ln != null) {
                    lns = lns + ln + "\n";
                    ln = br.readLine();
                }
                this.casedModelCache.put(k, CasedModelLoader.convert(lns, false));
            }
            catch (Throwable err) {
                FMLLog.info((String)("CasedModel " + k + " could not be loaded:"), (Object[])new Object[0]);
                err.printStackTrace();
            }
        }
    }
}

