/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.asm;

import java.io.File;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Level;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.nei.asm"})
public class NEICorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static File location;
    public static boolean missingCCL;

    public NEICorePlugin() {
        NEICorePlugin.cclCheck();
    }

    public String[] getASMTransformerClass() {
        if (missingCCL) {
            FMLLog.log((String)"NotEnoughItems", (Level)Level.FATAL, (String)"Missing CCL! not registering class transformer.", (Object[])new Object[0]);
            return new String[0];
        }
        return new String[]{"codechicken.nei.asm.NEITransformer"};
    }

    public String getModContainerClass() {
        return "codechicken.nei.NEIModContainer";
    }

    public String getSetupClass() {
        return "codechicken.nei.asm.NEICorePlugin";
    }

    public void injectData(Map<String, Object> data) {
        location = (File)data.get("coremodLocation");
        if (location == null) {
            location = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public Void call() {
        return null;
    }

    private static void cclCheck() {
        try {
            Class.forName("codechicken.lib.asm.ASMHelper", false, NEICorePlugin.class.getClassLoader());
            missingCCL = false;
        }
        catch (ClassNotFoundException cNFE) {
            cNFE.printStackTrace();
            missingCCL = true;
        }
    }

    static {
        missingCCL = false;
    }
}

