/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.lib.item.filtering.IItemFilter;
import codechicken.lib.item.filtering.IItemFilterProvider;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemList;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.ItemStackMap;
import codechicken.nei.ItemStackSet;
import codechicken.nei.PopupInputHandler;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.config.ItemPanelDumper;
import codechicken.nei.config.dumps.FluidRegistryDumper;
import codechicken.nei.config.dumps.ForgeRegistryDumper;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.jei.JEIIntegrationManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import codechicken.nei.recipe.potion.PotionRecipeHelper;
import codechicken.nei.thirdparty.colossalchests.ColossalChestsConfig;
import codechicken.nei.util.LogHelper;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistry;

public class ItemInfo {
    @Deprecated
    public static final ArrayListMultimap<Layout, IHighlightHandler> highlightHandlers = ArrayListMultimap.create();
    public static final ItemStackMap<String> nameOverrides = new ItemStackMap();
    public static final ItemStackSet hiddenItems = new ItemStackSet();
    public static final ItemStackSet finiteItems = new ItemStackSet();
    public static final ArrayListMultimap<Item, ItemStack> itemOverrides = ArrayListMultimap.create();
    public static final ArrayListMultimap<Item, ItemStack> itemVariants = ArrayListMultimap.create();
    public static final LinkedList<IInfiniteItemHandler> infiniteHandlers = new LinkedList();
    @Deprecated
    public static final ArrayListMultimap<Block, IHighlightHandler> highlightIdentifiers = ArrayListMultimap.create();
    public static final HashSet<Class<? extends Slot>> fastTransferExemptions = new HashSet();
    public static final HashSet<Class<? extends GuiContainer>> fastTransferContainerExemptions = new HashSet();
    public static final HashMap<Item, String> itemOwners = new HashMap();
    public static final HashMap<ItemStack, String> itemSearchNames = new HashMap();

    public static boolean isHidden(ItemStack stack) {
        return hiddenItems.contains(stack) || JEIIntegrationManager.isItemBlacklistedJEI(stack);
    }

    public static boolean isHidden(Item item) {
        return hiddenItems.containsAll(item) || JEIIntegrationManager.isItemBlacklistedJEI(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static String getNameOverride(ItemStack stack) {
        return nameOverrides.get(stack);
    }

    public static boolean canBeInfinite(ItemStack stack) {
        return !finiteItems.contains(stack);
    }

    @Deprecated
    public static List<ItemStack> getItemOverrides(Item item) {
        return itemOverrides.get((Object)item);
    }

    public static void preInit() {
        ItemMobSpawner.register();
    }

    public static void init() {
        ItemMobSpawner.initRender();
    }

    public static void load(World world) {
        ColossalChestsConfig.init();
        PotionRecipeHelper.init();
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.parseModItems();
        ItemMobSpawner.loadSpawners(world);
        ItemInfo.addSpawnEggs();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
        ItemInfo.addIDDumps();
        ItemInfo.addHiddenItemFilter();
        ItemInfo.addSearchOptimisation();
    }

    private static void addVanillaBlockProperties() {
        API.hideItem(new ItemStack(Blocks.field_150458_ak));
        API.hideItem(new ItemStack(Blocks.field_150470_am));
    }

    private static void addSearchOptimisation() {
        ItemList.loadCallbacks.add(new ItemList.ItemsLoadedCallback(){

            @Override
            public void itemsLoaded() {
                itemSearchNames.clear();
            }
        });
    }

    private static void addHiddenItemFilter() {
        API.addItemFilter(new IItemFilterProvider(){

            public IItemFilter getFilter() {
                return new IItemFilter(){

                    public boolean matches(ItemStack item) {
                        return !hiddenItems.contains(item);
                    }
                };
            }
        });
        API.addItemFilter(new IItemFilterProvider(){

            public IItemFilter getFilter() {
                return new IItemFilter(){

                    public boolean matches(ItemStack item) {
                        return !JEIIntegrationManager.isItemBlacklistedJEI(item);
                    }
                };
            }
        });
    }

    private static void addIDDumps() {
        API.addOption(new ForgeRegistryDumper<Item>("tools.dump.item"){

            @Override
            public IForgeRegistry<Item> registry() {
                return ForgeRegistries.ITEMS;
            }

            @Override
            public String[] dump(Item obj, ResourceLocation registryName) {
                int id = Item.func_150891_b((Item)obj);
                boolean hasBlock = Block.func_149634_a((Item)obj) != null && Block.func_149634_a((Item)obj) != Blocks.field_150350_a;
                return new String[]{registryName.toString(), Integer.toString(id), Boolean.toString(hasBlock), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Has Block", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<Block>("tools.dump.block"){

            @Override
            public IForgeRegistry<Block> registry() {
                return ForgeRegistries.BLOCKS;
            }

            @Override
            public String[] dump(Block obj, ResourceLocation registryName) {
                int id = Block.func_149682_b((Block)obj);
                boolean hasBlock = Item.func_150898_a((Block)obj) != null;
                return new String[]{registryName.toString(), Integer.toString(id), Boolean.toString(hasBlock), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Has Item", "Class"};
            }
        });
        API.addOption(new FluidRegistryDumper());
        API.addOption(new ForgeRegistryDumper<Potion>("tools.dump.potion"){

            @Override
            public IForgeRegistry<Potion> registry() {
                return ForgeRegistries.POTIONS;
            }

            @Override
            public String[] dump(Potion obj, ResourceLocation registryName) {
                int id = Potion.func_188409_a((Potion)obj);
                return new String[]{registryName.toString(), Integer.toString(id), Boolean.toString(obj.func_76398_f()), Boolean.toString(obj.func_188408_i()), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Is bad Effect", "Is beneficial", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<Biome>("tools.dump.biome"){

            @Override
            public IForgeRegistry<Biome> registry() {
                return ForgeRegistries.BIOMES;
            }

            @Override
            public String[] dump(Biome obj, ResourceLocation registryName) {
                int id = Biome.func_185362_a((Biome)obj);
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)obj);
                StringBuilder s_types = new StringBuilder();
                for (BiomeDictionary.Type t : types) {
                    if (s_types.length() > 0) {
                        s_types.append(", ");
                    }
                    s_types.append(t.name());
                }
                return new String[]{registryName.toString(), Integer.toString(id), obj.func_185359_l(), Float.toString(obj.func_180626_a(BlockPos.field_177992_a)), Float.toString(obj.func_76727_i()), Float.toString(obj.func_76741_f()), Float.toString(obj.func_185355_j()), Float.toString(obj.func_185360_m()), s_types.toString(), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Name", "Temperature", "Rainfall", "Spawn Chance", "Root Height", "Height Variation", "Types", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<SoundEvent>("tools.dump.sound_event"){

            @Override
            public IForgeRegistry<SoundEvent> registry() {
                return ForgeRegistries.SOUND_EVENTS;
            }

            @Override
            public String[] dump(SoundEvent obj, ResourceLocation registryName) {
                int id = SoundEvent.field_187505_a.func_148757_b((Object)obj);
                return new String[]{registryName.toString(), Integer.toString(id), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<Enchantment>("tools.dump.enchantment"){

            @Override
            public IForgeRegistry<Enchantment> registry() {
                return null;
            }

            @Override
            public String[] dump(Enchantment obj, ResourceLocation registryName) {
                int id = Enchantment.func_185258_b((Enchantment)obj);
                StringBuilder s_slots = new StringBuilder();
                for (EntityEquipmentSlot slot : obj.field_185263_a) {
                    if (s_slots.length() > 0) {
                        s_slots.append(", ");
                    }
                    s_slots.append(slot.func_188450_d());
                }
                return new String[]{registryName.toString(), Integer.toString(id), obj.func_77320_a(), obj.field_77351_y.toString(), Integer.toString(obj.func_77319_d()), Integer.toString(obj.func_77319_d()), obj.func_77324_c().name(), s_slots.toString(), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Name", "Type", "Min Level", "Max Level", "Rarity", "Slots", "Class"};
            }
        });
        API.addOption(new ItemPanelDumper("tools.dump.itempanel"));
    }

    private static void parseModItems() {
        HashMap<String, ItemStackSet> modSubsets = new HashMap<String, ItemStackSet>();
        for (Item item : Item.field_150901_e) {
            ResourceLocation ident = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
            if (ident == null) {
                LogHelper.error("Failed to find identifier for: " + item);
                continue;
            }
            String modId = ident.func_110624_b();
            itemOwners.put(item, modId);
            ItemStackSet itemset = (ItemStackSet)modSubsets.get(modId);
            if (itemset == null) {
                itemset = new ItemStackSet();
                modSubsets.put(modId, itemset);
            }
            itemset.with(item);
        }
        API.addSubset("Mod.Minecraft", (IItemFilter)modSubsets.remove("minecraft"));
        for (Map.Entry entry : modSubsets.entrySet()) {
            ModContainer mc = FMLCommonHandler.instance().findContainerFor(entry.getKey());
            if (mc == null) {
                LogHelper.error("Missing container for " + (String)entry.getKey());
                continue;
            }
            API.addSubset("Mod." + mc.getName(), (IItemFilter)entry.getValue());
        }
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new PopupInputHandler());
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addDefaultDropDowns() {
        API.addSubset("Items", new IItemFilter(){

            public boolean matches(ItemStack item) {
                return Block.func_149634_a((Item)item.func_77973_b()) == Blocks.field_150350_a;
            }
        });
        API.addSubset("Blocks", new IItemFilter(){

            public boolean matches(ItemStack item) {
                return Block.func_149634_a((Item)item.func_77973_b()) != Blocks.field_150350_a;
            }
        });
        API.addSubset("Blocks.MobSpawners", ItemStackSet.of(Blocks.field_150474_ac));
    }

    private static void searchItems() {
        ItemStackSet tools = new ItemStackSet();
        ItemStackSet picks = new ItemStackSet();
        ItemStackSet shovels = new ItemStackSet();
        ItemStackSet axes = new ItemStackSet();
        ItemStackSet hoes = new ItemStackSet();
        ItemStackSet swords = new ItemStackSet();
        ItemStackSet chest = new ItemStackSet();
        ItemStackSet helmets = new ItemStackSet();
        ItemStackSet legs = new ItemStackSet();
        ItemStackSet boots = new ItemStackSet();
        ItemStackSet other = new ItemStackSet();
        ItemStackSet ranged = new ItemStackSet();
        ItemStackSet food = new ItemStackSet();
        ItemStackSet potioningredients = new ItemStackSet();
        ArrayList<ItemStackSet> creativeTabRanges = new ArrayList<ItemStackSet>(CreativeTabs.field_78032_a.length);
        LinkedList stackList = new LinkedList();
        for (Item item : Item.field_150901_e) {
            if (item == null) continue;
            for (CreativeTabs itemTab : item.getCreativeTabs()) {
                if (itemTab == null) continue;
                while (itemTab.func_78021_a() >= creativeTabRanges.size()) {
                    creativeTabRanges.add(null);
                }
                ItemStackSet set = (ItemStackSet)creativeTabRanges.get(itemTab.func_78021_a());
                if (set == null) {
                    set = new ItemStackSet();
                    creativeTabRanges.set(itemTab.func_78021_a(), set);
                }
                stackList.clear();
                item.func_150895_a(item, itemTab, stackList);
                for (ItemStack stack : stackList) {
                    set.add(stack);
                }
            }
            if (item.func_77645_m()) {
                tools.with(item);
                if (item instanceof ItemPickaxe) {
                    picks.with(item);
                } else if (item instanceof ItemSpade) {
                    shovels.with(item);
                } else if (item instanceof ItemAxe) {
                    axes.with(item);
                } else if (item instanceof ItemHoe) {
                    hoes.with(item);
                } else if (item instanceof ItemSword) {
                    swords.with(item);
                } else if (item instanceof ItemArmor) {
                    switch (((ItemArmor)item).field_77881_a) {
                        case HEAD: {
                            helmets.with(item);
                            break;
                        }
                        case CHEST: {
                            chest.with(item);
                            break;
                        }
                        case LEGS: {
                            legs.with(item);
                            break;
                        }
                        case FEET: {
                            boots.with(item);
                        }
                    }
                } else if (item == Items.field_151032_g || item == Items.field_151031_f) {
                    ranged.with(item);
                } else if (item == Items.field_151112_aM || item == Items.field_151033_d || item == Items.field_151097_aZ) {
                    other.with(item);
                }
            }
            if (item instanceof ItemFood) {
                food.with(item);
            }
            try {
                LinkedList subItems = new LinkedList();
                item.func_150895_a(item, null, subItems);
                for (ItemStack stack : subItems) {
                    if (!PotionHelper.func_185205_a((ItemStack)stack)) continue;
                    BrewingRecipeHandler.ingredients.add(stack);
                    potioningredients.add(stack);
                }
            }
            catch (Exception e) {
                LogHelper.errorError("Error loading brewing ingredients for: " + item, e);
            }
        }
        API.addSubset("Items.Tools.Pickaxes", picks);
        API.addSubset("Items.Tools.Shovels", shovels);
        API.addSubset("Items.Tools.Axes", axes);
        API.addSubset("Items.Tools.Hoes", hoes);
        API.addSubset("Items.Tools.Other", other);
        API.addSubset("Items.Weapons.Swords", swords);
        API.addSubset("Items.Weapons.Ranged", ranged);
        API.addSubset("Items.Armor.ChestPlates", chest);
        API.addSubset("Items.Armor.Leggings", legs);
        API.addSubset("Items.Armor.Helmets", helmets);
        API.addSubset("Items.Armor.Boots", boots);
        API.addSubset("Items.Food", food);
        API.addSubset("Items.Potions.Ingredients", potioningredients);
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            ItemStackSet set;
            if (tab.func_78021_a() >= creativeTabRanges.size() || (set = (ItemStackSet)creativeTabRanges.get(tab.func_78021_a())) == null || set.isEmpty()) continue;
            API.addSubset("CreativeTabs." + I18n.func_135052_a((String)tab.func_78024_c(), (Object[])new Object[0]), set);
        }
        BrewingRecipeHandler.searchPotions();
    }

    private static void addSpawnEggs() {
    }

    private static void addEntityEgg(Class<? extends Entity> entity, int i, int j) {
        String id = EntityList.func_188430_a(entity);
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, i, j));
    }

    @Deprecated
    public static ArrayList<ItemStack> getIdentifierItems(World world, EntityPlayer player, RayTraceResult hit) {
        IShearable shearable;
        BlockPos pos = hit.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.containsKey(null)) {
            handlers.addAll(highlightIdentifiers.get(null));
        }
        if (highlightIdentifiers.containsKey((Object)block)) {
            handlers.addAll(highlightIdentifiers.get((Object)block));
        }
        for (IHighlightHandler ident : handlers) {
            ItemStack item = ident.identifyHighlight(world, player, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        ItemStack pick = block.getPickBlock(state, hit, world, pos, player);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(block.getDrops((IBlockAccess)world, pos, state, 0));
        }
        catch (Exception ident) {
            // empty catch block
        }
        if (block instanceof IShearable && (shearable = (IShearable)block).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos)) {
            items.addAll(shearable.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ItemStack(block, 1, block.func_176201_c(state)));
        }
        return items;
    }

    @Deprecated
    public static void registerHighlightHandler(IHighlightHandler handler, Layout ... layouts) {
        for (Layout layout : layouts) {
            highlightHandlers.get((Object)layout).add(handler);
        }
    }

    @Deprecated
    public static List<String> getText(ItemStack itemStack, World world, EntityPlayer player, RayTraceResult rayTraceResult) {
        List<String> retString = new ArrayList<String>();
        for (Layout layout : Layout.values()) {
            for (IHighlightHandler handler : highlightHandlers.get((Object)layout)) {
                retString = handler.handleTextData(itemStack, world, player, rayTraceResult, retString, layout);
            }
        }
        return retString;
    }

    public static String getSearchName(ItemStack stack) {
        String s = itemSearchNames.get(stack);
        if (s == null) {
            s = TextFormatting.func_110646_a((String)GuiContainerManager.concatenatedDisplayName(stack, true).toLowerCase());
            itemSearchNames.put(stack, s);
        }
        return s;
    }

    public static enum Layout {
        HEADER,
        BODY,
        FOOTER;

    }
}

