/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gyth.tileentity;

import net.darkhax.bookshelf.tileentity.TileEntityBasic;
import net.darkhax.gyth.api.GythApi;
import net.darkhax.gyth.api.TankTier;
import net.darkhax.gyth.tileentity.FluidTankTile;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityModularTank
extends TileEntityBasic {
    private TankTier tier;
    private String tierId;
    public FluidTankTile tank = new FluidTankTile(0);
    private int tierLookupAttempt = 0;
    private NBTTagCompound tagCache;

    public TileEntityModularTank() {
        this.tank.setTileEntity((TileEntity)this);
    }

    public void upgradeTank(TankTier upgradeTier, IBlockState state) {
        this.tier = upgradeTier;
        this.tank.setCapacity(upgradeTier.getCapacity());
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 8);
        this.func_70296_d();
    }

    public TankTier getTier() {
        if (this.tier == null && this.tierLookupAttempt < 5) {
            this.tier = GythApi.getTier(this.tierId);
            ++this.tierLookupAttempt;
        }
        return this.tier;
    }

    public void writeNBT(NBTTagCompound dataTag) {
        TankTier tankTier = this.getTier();
        if (tankTier != null && this.tank != null) {
            dataTag.func_74778_a("TierID", tankTier.identifier.toString());
            if (this.tank != null && this.tank.getFluid() != null) {
                NBTTagCompound tankTag = new NBTTagCompound();
                this.tank.getFluid().writeToNBT(tankTag);
                dataTag.func_74782_a("FluidData", (NBTBase)tankTag);
            }
        } else {
            this.tagCache.func_179237_a(dataTag);
        }
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.tagCache = dataTag;
        this.tierId = dataTag.func_74779_i("TierID");
        this.tier = GythApi.getTier(this.tierId);
        if (this.tier != null) {
            this.tank = dataTag.func_74764_b("FluidData") ? new FluidTankTile(FluidStack.loadFluidStackFromNBT((NBTTagCompound)dataTag.func_74775_l("FluidData")), this.tier.getCapacity()) : new FluidTankTile(this.tier.getCapacity());
        } else if (dataTag.func_74764_b("FluidData")) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)dataTag.func_74775_l("FluidData"));
            this.tank = new FluidTankTile(stack, stack.amount);
        }
        if (this.tank != null) {
            this.tank.setTileEntity((TileEntity)this);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }
}

