/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchcrumbs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.blay09.mods.twitchcrumbs.Twitchcrumbs;
import org.apache.commons.io.IOUtils;

public class CachedAPI {
    private static final long DEFAULT_CACHE_TIME = 86400000L;

    public static InputStream loadCachedAPI(String url, String fileName) throws IOException {
        return CachedAPI.loadCachedAPI(url, fileName, 86400000L);
    }

    public static InputStream loadCachedAPI(String url, String fileName, long maxCacheTime) throws IOException {
        return CachedAPI.loadCachedAPI(url, new File(CachedAPI.getCacheDirectory(), fileName), maxCacheTime);
    }

    public static InputStream loadCachedAPI(String url, File cacheFile, long maxCacheTime) throws IOException {
        InputStream in = CachedAPI.loadLocal(cacheFile, false, maxCacheTime);
        if (in == null) {
            in = CachedAPI.loadRemote(url);
            if (in == null) {
                in = CachedAPI.loadLocal(cacheFile, true, maxCacheTime);
                if (in == null) {
                    throw new IOException("Could not grab remote source and no local cache present.");
                }
            } else {
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(cacheFile));
                }
                catch (IOException e) {
                    Twitchcrumbs.logger.error("Failed to cache {}: {}", new Object[]{url, e});
                }
            }
        }
        return in;
    }

    private static InputStream loadLocal(File file, boolean force, long maxCacheTime) throws IOException {
        if (file.exists() && (force || System.currentTimeMillis() - file.lastModified() < maxCacheTime)) {
            return new FileInputStream(file);
        }
        return null;
    }

    private static InputStream loadRemote(String url) throws IOException {
        URL apiURL = new URL(url);
        return apiURL.openStream();
    }

    public static File getCacheDirectory() {
        File file = new File("twitchcrumbs-cache/");
        file.mkdirs();
        return file;
    }
}

