/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common;

import java.io.File;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.xalcon.energyconverters.EnergyConverters;

public class EnergyConvertersConfig {
    private final Configuration config;
    private final Property propertyEnergyBridgeMax;
    private final Property propertyEuConversion;
    private final Property propertyRfConversion;
    private final Property propertyConversionLoss;
    private double bridgeEnergyBuffer;
    private double ic2Conversion;
    private double rfConversion;
    private double conversionLoss;

    public double getBridgeEnergyBuffer() {
        return this.bridgeEnergyBuffer;
    }

    public double getIc2Conversion() {
        return this.ic2Conversion;
    }

    public double getRfConversion() {
        return this.rfConversion;
    }

    public double getConversionLoss() {
        return this.conversionLoss;
    }

    public EnergyConvertersConfig(File file) {
        this.config = new Configuration(file);
        this.config.load();
        this.propertyEnergyBridgeMax = this.config.get("settings", "energyBridgeBuffer", 10000.0, "Maximum amount of energy the bridge can buffer. This needs to be >0 otherwise, the bridge is not able to convert energy");
        this.propertyEuConversion = this.config.get("settings", "euConversionFactor", 4.0, "EU (IndustrialCraft2) to Energy Converters internal energy conversion factor.");
        this.propertyRfConversion = this.config.get("settings", "rfConversionFactor", 1.0, "RF (RedstoneFlux and ForgeEnergy) to Energy Converters internal energy conversion factor.");
        this.propertyConversionLoss = this.config.get("settings", "conversionLoss", 0.0, "Percentage of energy lost on conversion.", 0.0, 100.0);
        this.syncConfig();
    }

    private void syncConfig() {
        this.bridgeEnergyBuffer = this.propertyEnergyBridgeMax.getDouble();
        this.ic2Conversion = this.propertyEuConversion.getDouble();
        this.rfConversion = this.propertyRfConversion.getDouble();
        this.conversionLoss = this.propertyConversionLoss.getDouble() / 100.0;
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public String getString() {
        return this.config.toString();
    }

    public List<IConfigElement> getConfigElements() {
        return new ConfigElement(this.config.getCategory("settings")).getChildElements();
    }

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if ("energyconverters".equals(event.getModID())) {
                EnergyConverters.getConfig().syncConfig();
            }
        }
    }
}

