/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Mixer")
public class Mixer {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack fluidInput, IIngredient[] itemInputs, int energy) {
        Object[] adds = null;
        if (itemInputs != null) {
            adds = new Object[itemInputs.length];
            for (int i = 0; i < itemInputs.length; ++i) {
                adds[i] = CraftTweakerHelper.toObject(itemInputs[i]);
            }
        }
        MixerRecipe r = new MixerRecipe(CraftTweakerHelper.toFluidStack(output), CraftTweakerHelper.toFluidStack(fluidInput), adds, energy);
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        if (CraftTweakerHelper.toFluidStack(output) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFluid(CraftTweakerHelper.toFluidStack(output)));
        }
    }

    private static class RemoveFluid
    implements IUndoableAction {
        private final FluidStack output;
        ArrayList<MixerRecipe> removedRecipes = new ArrayList();

        public RemoveFluid(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<MixerRecipe> it = MixerRecipe.recipeList.iterator();
            while (it.hasNext()) {
                MixerRecipe r = it.next();
                if (r == null || r.fluidOutput == null || !r.fluidOutput.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (MixerRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    MixerRecipe.recipeList.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Mixer Recipes for Fluid " + this.output.getLocalizedName();
        }

        public String describeUndo() {
            return "Re-Adding Mixer Recipes for Fluid " + this.output.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final MixerRecipe recipe;

        public Add(MixerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MixerRecipe.recipeList.add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MixerRecipe.recipeList.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding Fermenter Recipe for Fluid " + this.recipe.fluidOutput.getLocalizedName();
        }

        public String describeUndo() {
            return "Removing Fermenter Recipe for Fluid " + this.recipe.fluidOutput.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

