/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.items.ItemShader;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import com.google.common.collect.ArrayListMultimap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.TinyPotatoRenderEvent;

public class BotaniaHelper
extends IECompatModule {
    EnumRarity rariryRelic;
    private static ArrayListMultimap<String, ItemRevolver.SpecialRevolver> nameToSpecial = ArrayListMultimap.create();
    EntityItem revolverEntity;

    @Override
    public void preInit() {
        BulletHandler.registerBullet("terrasteel", new ItemBullet.HomingBullet(Config.IEConfig.Tools.bulletDamage_Homing, new ResourceLocation("immersiveengineering:items/bullet_terrasteel")));
        BulletHandler.homingCartridges.add("terrasteel");
    }

    @Override
    public void init() {
        BlueprintCraftingRecipe.addRecipe("specialBullet", BulletHandler.getBulletStack("terrasteel"), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.field_151016_H, "nuggetTerrasteel", "nuggetTerrasteel");
        try {
            Class<?> c_BotaniaAPI = Class.forName("vazkii.botania.api.BotaniaAPI");
            Method m_blacklistBlockFromMagnet = c_BotaniaAPI.getDeclaredMethod("blacklistBlockFromMagnet", Block.class, Integer.TYPE);
            m_blacklistBlockFromMagnet.invoke(null, IEContent.blockConveyor, 0);
        }
        catch (Exception e) {
            IELogger.error("[Botania] Failed to protect IE conveyors against Botania's magnets");
            e.printStackTrace();
        }
        this.rariryRelic = EnumRarity.valueOf((String)"RELIC");
        if (this.rariryRelic != null) {
            ShaderRegistry.rarityWeightMap.put(this.rariryRelic, 2);
            this.makeShaderRelic("The Kindled");
            this.makeShaderRelic("Dark Fire");
            ShaderRegistry.ShaderRegistryEntry entry = ItemShader.addShader("Terra", 1, this.rariryRelic, -12702444, -13954808, -12468966, -13757942).setInfo(null, "Botania", "terra");
            entry.getCase("immersiveengineering:revolver").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/livingwood5"), -1).setTextureBounds(0.1328125, 0.1875, 0.2578125, 0.3125));
            entry.getCase("immersiveengineering:drill").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/alfheimPortalInside"), -1).setTextureBounds(0.21875, 0.15625, 0.40625, 0.34375));
            entry.getCase("immersiveengineering:railgun").addLayers(new ShaderCase.ShaderLayer(new ResourceLocation("botania:blocks/storage1"), -6388757).setTextureBounds(0.859375, 0.65625, 1.0, 0.90625).setCutoutBounds(0.1875, 0.0, 0.75, 1.0));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    void makeShaderRelic(String shader) {
        ShaderRegistry.ShaderRegistryEntry entry = ShaderRegistry.shaderRegistry.get(shader);
        entry.rarity = this.rariryRelic;
        entry.setReplicationCost(ShaderRegistry.defaultReplicationCost.copyWithMultipliedSize(8.0));
    }

    @Override
    public void postInit() {
        new ThreadContributorToNameFormatter();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && event.getEntityLiving().getClass().getName().endsWith("EntityDoppleganger")) {
            NBTTagCompound tag = new NBTTagCompound();
            event.getEntityLiving().func_70014_b(tag);
            if (tag.func_74767_n("hardMode")) {
                for (EntityItem item : event.getDrops()) {
                    if (item == null || item.func_92059_d() == null || !IEContent.itemShaderBag.equals(item.func_92059_d().func_77973_b())) continue;
                    ItemNBTHelper.setString(item.func_92059_d(), "rarity", "RELIC");
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPotatoRender(TinyPotatoRenderEvent event) {
        if (event.tile.func_145831_w() == null) {
            return;
        }
        if (this.revolverEntity == null) {
            this.revolverEntity = new EntityItem(event.tile.func_145831_w(), 0.0, 0.0, 0.0, new ItemStack((Item)IEContent.itemRevolver));
            this.revolverEntity.field_70290_d = 0.0f;
        }
        try {
            List list;
            String formattedName = event.name.replace("_", " ");
            ItemRevolver.SpecialRevolver special = null;
            if (formattedName.equalsIgnoreCase("Mr Damien Hazard") || formattedName.equalsIgnoreCase("Mr Hazard")) {
                special = ItemRevolver.specialRevolversByTag.get("dev");
            } else if (event.name.equalsIgnoreCase("BluSunrize")) {
                special = ItemRevolver.specialRevolversByTag.get("fenrir");
            } else if (nameToSpecial.containsKey((Object)event.name.toLowerCase(Locale.ENGLISH)) && (list = nameToSpecial.get((Object)event.name.toLowerCase(Locale.ENGLISH))) != null && list.size() > 0) {
                long ticks = event.tile.func_145831_w() != null ? event.tile.func_145831_w().func_82737_E() / 100L : 0L;
                special = (ItemRevolver.SpecialRevolver)list.get((int)(ticks % (long)list.size()));
            }
            if (special != null) {
                GlStateManager.func_179094_E();
                ((ItemRevolver)IEContent.itemRevolver).applySpecialCrafting(this.revolverEntity.func_92059_d(), special);
                GlStateManager.func_179137_b((double)-0.16, (double)1.45, (double)-0.2);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.625f, (float)0.625f, (float)0.625f);
                ClientUtils.mc().func_175598_ae().func_188391_a((Entity)this.revolverEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
                GlStateManager.func_179121_F();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ThreadContributorToNameFormatter
    extends Thread {
        public ThreadContributorToNameFormatter() {
            this.setName("Immersive Engineering Contributors Name Finder Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                if (ImmersiveEngineering.ThreadContributorSpecialsDownloader.activeThread != null) {
                    ImmersiveEngineering.ThreadContributorSpecialsDownloader.activeThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (String uuid : ItemRevolver.specialRevolvers.keySet()) {
                nameToSpecial.putAll((Object)ImmersiveEngineering.proxy.getNameFromUUID(uuid).toLowerCase(Locale.ENGLISH), (Iterable)ItemRevolver.specialRevolvers.get((Object)uuid));
            }
        }
    }
}

