/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityChargingStation
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IPlayerInteraction {
    public FluxStorageAdvanced energyStorage = new FluxStorageAdvanced(32000);
    public EnumFacing facing = EnumFacing.NORTH;
    public ItemStack[] inventory = new ItemStack[1];
    private boolean charging = true;
    public int comparatorOutput = 0;
    EnergyHelper.IEForgeEnergyWrapper wrapperDown = new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.DOWN);
    EnergyHelper.IEForgeEnergyWrapper wrapperDir = new EnergyHelper.IEForgeEnergyWrapper(this, this.facing.func_176734_d());
    IItemHandler insertionHandler = new IEInventoryHandler(1, this);

    public void func_73660_a() {
        float max;
        if (EnergyHelper.isFluxItem(this.inventory[0])) {
            if (this.field_145850_b.field_72995_K && this.charging) {
                float charge = 0.0f;
                max = EnergyHelper.getMaxEnergyStored(this.inventory[0]);
                if (max > 0.0f) {
                    charge = (float)EnergyHelper.getEnergyStored(this.inventory[0]) / max;
                }
                for (int i = 0; i < 3; ++i) {
                    long time = this.field_145850_b.func_82737_E();
                    if (!(charge >= 1.0f) && (time % 12L < (long)(i * 4) || time % 12L > (long)(i * 4 + 2))) continue;
                    int shift = i - 1;
                    double x = (double)this.func_174877_v().func_177958_n() + 0.5 + (this.facing == EnumFacing.WEST ? -0.46875 : (this.facing == EnumFacing.EAST ? 0.46875 : (this.facing == EnumFacing.NORTH ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    double y = (double)this.func_174877_v().func_177956_o() + 0.25;
                    double z = (double)this.func_174877_v().func_177952_p() + 0.5 + (this.facing == EnumFacing.NORTH ? -0.46875 : (this.facing == EnumFacing.SOUTH ? 0.46875 : (this.facing == EnumFacing.EAST ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                    ImmersiveEngineering.proxy.spawnRedstoneFX(this.field_145850_b, x, y, z, 0.25, 0.25, 0.25, 0.5f, 1.0f - charge, charge, 0.0f);
                }
            } else if (this.charging) {
                if (this.energyStorage.getEnergyStored() == 0) {
                    this.charging = false;
                    this.markContainingBlockForUpdate(null);
                    return;
                }
                if (EnergyHelper.isFluxItem(this.inventory[0])) {
                    int stored = EnergyHelper.getEnergyStored(this.inventory[0]);
                    int max2 = EnergyHelper.getMaxEnergyStored(this.inventory[0]);
                    int space = max2 - stored;
                    if (space > 0) {
                        int energyDecNew;
                        int energyDec = 10 * stored / max2;
                        int insert = Math.min(space, Math.max(this.energyStorage.getAverageInsertion(), Config.IEConfig.Machines.charger_consumption));
                        int accepted = Math.min(EnergyHelper.insertFlux(this.inventory[0], insert, true), this.energyStorage.extractEnergy(insert, true));
                        if ((accepted = this.energyStorage.extractEnergy(accepted, false)) > 0) {
                            stored += EnergyHelper.insertFlux(this.inventory[0], accepted, false);
                        }
                        if (energyDec != (energyDecNew = 10 * stored / max2)) {
                            this.markContainingBlockForUpdate(null);
                        }
                    }
                }
            } else if ((double)this.energyStorage.getEnergyStored() >= (double)this.energyStorage.getMaxEnergyStored() * 0.95) {
                this.charging = true;
                this.markContainingBlockForUpdate(null);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F)) {
            int i;
            float charge = 0.0f;
            if (EnergyHelper.isFluxItem(this.inventory[0]) && (max = (float)EnergyHelper.getMaxEnergyStored(this.inventory[0])) > 0.0f) {
                charge = (float)EnergyHelper.getEnergyStored(this.inventory[0]) / max;
            }
            if ((i = (int)(15.0f * charge)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.inventory[0] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("inventory"));
        this.charging = nbt.func_74767_n("charging");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("charging", this.charging);
        if (this.inventory[0] != null) {
            nbt.func_74782_a("inventory", (NBTBase)this.inventory[0].func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return facing == EnumFacing.DOWN || facing == this.facing.func_176734_d() ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return this.wrapperDown;
        }
        if (facing == this.facing.func_176734_d()) {
            if (this.wrapperDir.side != this.facing.func_176734_d()) {
                this.wrapperDir = new EnergyHelper.IEForgeEnergyWrapper(this, this.facing.func_176734_d());
            }
            return this.wrapperDir;
        }
        return null;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{this.facing.func_176740_k() == EnumFacing.Axis.X ? 0.0f : 0.125f, 0.0f, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0.0f : 0.125f, this.facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.875f, 1.0f, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.875f};
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return EnergyHelper.isFluxItem(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (EnergyHelper.isFluxItem(heldItem)) {
            ItemStack stored = this.inventory[0] != null ? this.inventory[0].func_77946_l() : null;
            this.inventory[0] = heldItem.func_77946_l();
            player.func_184611_a(hand, stored);
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (this.inventory[0] != null) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_70099_a(this.inventory[0].func_77946_l(), 0.5f);
            }
            this.inventory[0] = null;
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }
}

