/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import java.util.LinkedHashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WireType {
    private static LinkedHashSet<WireType> values = new LinkedHashSet();
    public static String[] uniqueNames = new String[]{"COPPER", "ELECTRUM", "STEEL", "STRUCTURE_ROPE", "STRUCTURE_STEEL", "REDSTONE"};
    public static double[] wireLossRatio;
    public static int[] wireTransferRate;
    public static int[] wireColouration;
    public static int[] wireLength;
    public static Item ieWireCoil;
    public static double[] renderDiameter;
    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite iconDefaultWire;
    public static WireType COPPER;
    public static WireType ELECTRUM;
    public static WireType STEEL;
    public static WireType STRUCTURE_ROPE;
    public static WireType STRUCTURE_STEEL;
    public static WireType REDSTONE;

    public static LinkedHashSet<WireType> getValues() {
        return values;
    }

    public static WireType getValue(String name) {
        for (WireType type : values) {
            if (type == null || !type.getUniqueName().equals(name)) continue;
            return type;
        }
        return COPPER;
    }

    public WireType() {
        values.add(this);
    }

    public abstract String getUniqueName();

    public abstract double getLossRatio();

    public abstract int getTransferRate();

    public abstract int getColour(ImmersiveNetHandler.Connection var1);

    public abstract double getSlack();

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection var1);

    public abstract int getMaxLength();

    public abstract ItemStack getWireCoil();

    public ItemStack getWireCoil(ImmersiveNetHandler.Connection c) {
        return this.getWireCoil();
    }

    public abstract double getRenderDiameter();

    public abstract boolean isEnergyWire();

    static {
        renderDiameter = new double[]{0.03125, 0.03125, 0.0625, 0.0625, 0.0625, 0.03125};
        COPPER = new IEBASE(0);
        ELECTRUM = new IEBASE(1);
        STEEL = new IEBASE(2);
        STRUCTURE_ROPE = new IEBASE(3);
        STRUCTURE_STEEL = new IEBASE(4);
        REDSTONE = new IEBASE(5);
    }

    private static class IEBASE
    extends WireType {
        final int ordinal;

        public IEBASE(int ordinal) {
            this.ordinal = ordinal;
        }

        @Override
        public double getLossRatio() {
            return Math.abs(wireLossRatio[this.ordinal]);
        }

        @Override
        public int getTransferRate() {
            return Math.abs(wireTransferRate[this.ordinal]);
        }

        @Override
        public int getColour(ImmersiveNetHandler.Connection connection) {
            return wireColouration[this.ordinal];
        }

        @Override
        public double getSlack() {
            return 1.005;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection connection) {
            return iconDefaultWire;
        }

        @Override
        public int getMaxLength() {
            return wireLength[this.ordinal];
        }

        @Override
        public ItemStack getWireCoil() {
            return new ItemStack(ieWireCoil, 1, this.ordinal);
        }

        @Override
        public String getUniqueName() {
            return uniqueNames[this.ordinal];
        }

        @Override
        public double getRenderDiameter() {
            return renderDiameter[this.ordinal];
        }

        @Override
        public boolean isEnergyWire() {
            return this.ordinal < 3;
        }
    }
}

