/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.client.settings;

import com.gendeathrow.mputils.client.gui.Gui_QuickMenu;
import com.gendeathrow.mputils.client.settings.MPUtils_SaveHandler;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class QuickCommandManager {
    public static QuickCommandManager instance = new QuickCommandManager();
    public static ArrayList<CommandElement> commandList = new ArrayList(10);
    public static ArrayList<CommandElement> globalCommandList = new ArrayList(10);

    public void removeCommand(ArrayList<CommandElement> list, int rmv) {
        list.set(rmv, null);
        MPUtils_SaveHandler.saveSettings();
    }

    public void addCommand(ArrayList<CommandElement> list, int id, CommandElement cmd) {
        if (list.get(id) == null) {
            list.set(id, cmd);
        }
        MPUtils_SaveHandler.saveSettings();
    }

    public static void load(ArrayList<CommandElement> list, NBTTagCompound tag) {
        list.clear();
        NBTTagCompound nbtCom = tag.func_74775_l("quickcommands");
        QuickCommandManager.ReadNBT(list, nbtCom);
    }

    public static void save(ArrayList<CommandElement> list, NBTTagCompound mainTag) {
        NBTTagCompound cmdCatTag = new NBTTagCompound();
        for (int i = 0; i <= 9; ++i) {
            NBTTagCompound cmdTag = new NBTTagCompound();
            CommandElement commandElement = list.get(i);
            if (commandElement != null) {
                cmdTag.func_74778_a("title", commandElement.title);
                cmdTag.func_74778_a("cmd", commandElement.getCommand());
                cmdCatTag.func_74782_a("c" + i, (NBTBase)cmdTag);
            }
            cmdCatTag.func_74757_a("isPaused", Gui_QuickMenu.pauseGame);
        }
        mainTag.func_74782_a("quickcommands", (NBTBase)cmdCatTag);
    }

    public static ArrayList<CommandElement> getList(int list) {
        if (list == 0) {
            return commandList;
        }
        if (list == 1) {
            return globalCommandList;
        }
        return commandList;
    }

    private static void ReadNBT(ArrayList<CommandElement> list, NBTTagCompound nbt) {
        for (int i = 0; i <= 9; ++i) {
            String key = "c" + i;
            if (nbt.func_74764_b(key)) {
                NBTTagCompound cmd = nbt.func_74775_l(key);
                QuickCommandManager quickCommandManager = instance;
                quickCommandManager.getClass();
                CommandElement element = quickCommandManager.new CommandElement(cmd.func_74779_i("title"), cmd.func_74779_i("cmd"));
                list.add(element);
            } else {
                list.add(null);
            }
            if (!nbt.func_74764_b("isPaused")) continue;
            Gui_QuickMenu.pauseGame = nbt.func_74767_n("isPaused");
        }
    }

    private static void SaveNBT(ArrayList<CommandElement> list, NBTTagCompound nbt) {
        for (int i = 0; i <= 9; ++i) {
            CommandElement cmd = list.get(i);
            NBTTagCompound cmdTag = new NBTTagCompound();
            if (cmd == null) continue;
            cmdTag.func_74778_a("title", cmd.title);
            cmdTag.func_74778_a("cmd", cmd.command);
            nbt.func_74782_a("c" + i, (NBTBase)cmdTag);
        }
    }

    static {
        QuickCommandManager quickCommandManager = instance;
        quickCommandManager.getClass();
        commandList.add(quickCommandManager.new CommandElement("Survival", "/gamemode s"));
        QuickCommandManager quickCommandManager2 = instance;
        quickCommandManager2.getClass();
        commandList.add(quickCommandManager2.new CommandElement("Creative", "/gamemode c"));
        QuickCommandManager quickCommandManager3 = instance;
        quickCommandManager3.getClass();
        commandList.add(quickCommandManager3.new CommandElement("Toggle Rain", "/toggledownfall"));
        QuickCommandManager quickCommandManager4 = instance;
        quickCommandManager4.getClass();
        commandList.add(quickCommandManager4.new CommandElement("MPHand", "/mp hand"));
        QuickCommandManager quickCommandManager5 = instance;
        quickCommandManager5.getClass();
        commandList.add(quickCommandManager5.new CommandElement("MPHotbar", "/mputil hotbar"));
        QuickCommandManager quickCommandManager6 = instance;
        quickCommandManager6.getClass();
        commandList.add(quickCommandManager6.new CommandElement("MPInv", "/mp inventory"));
        QuickCommandManager quickCommandManager7 = instance;
        quickCommandManager7.getClass();
        commandList.add(quickCommandManager7.new CommandElement("Looking At", "/mputil lookingat"));
        commandList.add(null);
        commandList.add(null);
        commandList.add(null);
        QuickCommandManager quickCommandManager8 = instance;
        quickCommandManager8.getClass();
        globalCommandList.add(quickCommandManager8.new CommandElement("Survival", "/gamemode s"));
        QuickCommandManager quickCommandManager9 = instance;
        quickCommandManager9.getClass();
        globalCommandList.add(quickCommandManager9.new CommandElement("Creative", "/gamemode c"));
        QuickCommandManager quickCommandManager10 = instance;
        quickCommandManager10.getClass();
        globalCommandList.add(quickCommandManager10.new CommandElement("Toggle Rain", "/toggledownfall"));
        QuickCommandManager quickCommandManager11 = instance;
        quickCommandManager11.getClass();
        globalCommandList.add(quickCommandManager11.new CommandElement("MPHand", "/mp hand"));
        QuickCommandManager quickCommandManager12 = instance;
        quickCommandManager12.getClass();
        globalCommandList.add(quickCommandManager12.new CommandElement("MPHotbar", "/mputil hotbar"));
        QuickCommandManager quickCommandManager13 = instance;
        quickCommandManager13.getClass();
        globalCommandList.add(quickCommandManager13.new CommandElement("MPInv", "/mp inventory"));
        QuickCommandManager quickCommandManager14 = instance;
        quickCommandManager14.getClass();
        globalCommandList.add(quickCommandManager14.new CommandElement("Looking At", "/mputil lookingat"));
        globalCommandList.add(null);
        globalCommandList.add(null);
        globalCommandList.add(null);
    }

    public class CommandElement {
        String title;
        String command;
        boolean isBlank = false;
        boolean toggleBoolen = false;

        public CommandElement(String title, String command) {
            this.title = title;
            this.command = command;
            this.isBlank = false;
        }

        public CommandElement(String title, String command, boolean isBlank) {
            this.title = title;
            this.command = command;
            this.isBlank = isBlank;
        }

        public String getCommand() {
            return this.command;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isBlank() {
            return this.isBlank;
        }

        public void setCommand(String text) {
            this.command = text;
        }

        public void setTitle(String text) {
            this.title = text;
        }

        public String parseCommand() {
            String parsed = this.command;
            this.toggleBoolen = !this.toggleBoolen;
            parsed = this.command.replaceAll("\\@t", this.toggleBoolen + "");
            return parsed;
        }
    }
}

