/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.util.Location2I;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class MazeGenerator {
    private int width;
    private int height;
    private int[][] map;
    private ArrayList<Location2I> walls = new ArrayList();
    private Map<BlockPos, IBlockState> blockStorgae = new HashMap<BlockPos, IBlockState>();
    private Map<BlockPos, NBTTagCompound> tileStorgae = new HashMap<BlockPos, NBTTagCompound>();
    private Random r = new Random();
    private int currentX = 1;
    private int currentY = 1;
    private final int nonWall = 0;
    private final int wall = 1;
    private Location2I endBlock;
    public BlockPos endBlockWorldCords;

    public void generate(World world, int x1, int y1, int z1, int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.map[x][y] = 1;
            }
        }
        this.map[1][1] = 0;
        this.currentX = 1;
        this.currentY = 1;
        Location2I current = new Location2I(this.currentX, this.currentY);
        Location2I north = current.add(0, -1);
        Location2I east = current.add(1, 0);
        Location2I south = current.add(0, 1);
        Location2I west = current.add(-1, 0);
        if (north.getY() > 0 && this.map[north.getX()][north.getY()] == 1 && this.map[north.getX()][north.getY() - 1] == 1) {
            this.walls.add(north);
        }
        if (east.getX() < width && this.map[east.getX()][east.getY()] == 1 && this.map[east.getX() + 1][east.getY()] == 1) {
            this.walls.add(east);
        }
        if (south.getY() < height && this.map[south.getX()][south.getY()] == 1 && this.map[south.getX()][south.getY() + 1] == 1) {
            this.walls.add(south);
        }
        if (west.getX() > 0 && this.map[west.getX()][west.getY()] == 1 && this.map[west.getX() - 1][west.getY()] == 1) {
            this.walls.add(west);
        }
        int randomLoc = 0;
        while (this.walls.size() > 0) {
            randomLoc = this.r.nextInt(this.walls.size());
            this.currentX = this.walls.get(randomLoc).getX();
            this.currentY = this.walls.get(randomLoc).getY();
            current.setXY(this.currentX, this.currentY);
            north = current.add(0, -1);
            east = current.add(1, 0);
            south = current.add(0, 1);
            west = current.add(-1, 0);
            if (!this.checkwalls(current)) {
                this.map[this.currentX][this.currentY] = 0;
                this.walls.remove(randomLoc);
                if (north.getY() - 1 > 0 && this.map[north.getX()][north.getY()] == 1 && this.map[north.getX()][north.getY() - 1] == 1) {
                    this.walls.add(north);
                }
                if (east.getX() + 1 < width && this.map[east.getX()][east.getY()] == 1 && this.map[east.getX() + 1][east.getY()] == 1) {
                    this.walls.add(east);
                }
                if (south.getY() + 1 < height && this.map[south.getX()][south.getY()] == 1 && this.map[south.getX()][south.getY() + 1] == 1) {
                    this.walls.add(south);
                }
                if (west.getX() - 1 <= 0 || this.map[west.getX()][west.getY()] != 1 || this.map[west.getX() - 1][west.getY()] != 1) continue;
                this.walls.add(west);
                continue;
            }
            this.walls.remove(randomLoc);
        }
        int endBlockX = width - 1;
        int endBlockZ = height - 1;
        boolean run = true;
        int i = 0;
        int xx = 0;
        int zz = 0;
        while (run) {
            for (xx = 0; xx <= i; ++xx) {
                for (zz = i; zz >= 0; --zz) {
                    if (this.map[endBlockX - xx][endBlockZ - zz] != this.nonWall || !run) continue;
                    this.endBlock = new Location2I(endBlockX - xx, endBlockZ - zz);
                    run = false;
                }
            }
            ++i;
        }
        this.placeBlocks(world, new BlockPos(x1, y1, z1));
    }

    private boolean checkwalls(Location2I loc) {
        Location2I north = loc.add(0, -1);
        Location2I east = loc.add(1, 0);
        Location2I south = loc.add(0, 1);
        Location2I west = loc.add(-1, 0);
        int yes = 0;
        if (north.getY() >= 0 && this.map[north.getX()][north.getY()] == 0) {
            ++yes;
        }
        if (east.getX() < this.width && this.map[east.getX()][east.getY()] == 0) {
            ++yes;
        }
        if (south.getY() < this.height && this.map[south.getX()][south.getY()] == 0) {
            ++yes;
        }
        if (west.getX() >= 0 && this.map[west.getX()][west.getY()] == 0) {
            ++yes;
        }
        return yes > 1;
    }

    private void placeBlocks(World world, BlockPos pos) {
        TileEntity temp;
        int xoff = pos.func_177958_n() - this.width / 2;
        int zoff = pos.func_177952_p() - this.height / 2;
        NBTTagCompound nbt = new NBTTagCompound();
        for (int xx = 0; xx < this.width; ++xx) {
            for (int zz = 0; zz < this.height; ++zz) {
                int yy;
                if (this.map[xx][zz] == 0) {
                    for (yy = -1; yy < 3; ++yy) {
                        this.blockStorgae.put(new BlockPos(xoff + xx, pos.func_177956_o() + yy, zoff + zz), world.func_180495_p(new BlockPos(xoff + xx, pos.func_177956_o() + yy, zoff + zz)));
                        temp = world.func_175625_s(new BlockPos(xoff + xx, pos.func_177956_o() + yy, zoff + zz));
                        if (temp == null) continue;
                        temp.func_189515_b(nbt);
                        this.tileStorgae.put(new BlockPos(xoff + xx, pos.func_177956_o() + yy, zoff + zz), nbt);
                    }
                    world.func_175656_a(new BlockPos(xoff + xx, pos.func_177956_o() - 1, zoff + zz), Blocks.field_150357_h.func_176223_P());
                    world.func_175656_a(new BlockPos(xoff + xx, pos.func_177956_o(), zoff + zz), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP));
                    world.func_175698_g(new BlockPos(xoff + xx, pos.func_177956_o() + 1, zoff + zz));
                    world.func_175656_a(new BlockPos(xoff + xx, pos.func_177956_o() + 2, zoff + zz), Blocks.field_150357_h.func_176223_P());
                    continue;
                }
                for (yy = -1; yy < 3; ++yy) {
                    BlockPos tempPos = new BlockPos(xoff + xx, pos.func_177956_o() + yy, zoff + zz);
                    this.blockStorgae.put(tempPos, world.func_180495_p(tempPos));
                    temp = world.func_175625_s(tempPos);
                    if (temp == null) continue;
                    temp.func_189515_b(nbt);
                    this.tileStorgae.put(new BlockPos(xoff + xx, pos.func_177956_o() + yy, zoff + zz), nbt);
                }
                world.func_175698_g(new BlockPos(xoff + xx, pos.func_177956_o() - 1, zoff + zz));
                world.func_175656_a(new BlockPos(xoff + xx, pos.func_177956_o(), zoff + zz), Blocks.field_150357_h.func_176223_P());
                world.func_175656_a(new BlockPos(xoff + xx, pos.func_177956_o() + 1, zoff + zz), Blocks.field_150357_h.func_176223_P());
                world.func_175698_g(new BlockPos(xoff + xx, pos.func_177956_o() + 2, zoff + zz));
            }
        }
        this.endBlockWorldCords = new BlockPos(xoff + this.endBlock.getX(), pos.func_177956_o(), zoff + this.endBlock.getY());
        world.func_175656_a(new BlockPos(xoff + this.endBlock.getX(), pos.func_177956_o(), zoff + this.endBlock.getY()), Blocks.field_150472_an.func_176223_P());
        temp = world.func_175625_s(new BlockPos(xoff + this.endBlock.getX(), pos.func_177956_o(), zoff + this.endBlock.getY()));
        if (temp instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)temp;
            sign.field_145915_a[0] = new TextComponentString("Break me");
            sign.field_145915_a[1] = new TextComponentString("To beat the");
            sign.field_145915_a[2] = new TextComponentString("Maze");
        }
    }

    public void endMaze(World world) {
        for (BlockPos loc : this.blockStorgae.keySet()) {
            world.func_180501_a(loc, this.blockStorgae.get(loc), 2);
        }
        for (BlockPos loc : this.tileStorgae.keySet()) {
            world.func_175690_a(loc, TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tileStorgae.get(loc)));
        }
    }
}

