/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;

public class CustomUserReward
implements IChanceCubeReward {
    private String userName = "";
    private UUID uuid = null;
    private String type;
    private List<BasicReward> customRewards = new ArrayList<BasicReward>();

    public CustomUserReward(String un, final UUID uuid) {
        JsonElement userRewards;
        JsonElement users;
        if (!CCubesSettings.userSpecificRewards) {
            return;
        }
        try {
            users = HTTPUtil.getWebFile("https://api.theprogrammingturkey.com/chance_cubes/custom_rewards/UserList.json", new CustomEntry[0]);
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the list of users with custom rewards!");
            return;
        }
        for (JsonElement user : users.getAsJsonArray()) {
            if (!user.getAsJsonObject().get("UUID").getAsString().equalsIgnoreCase(uuid.toString())) continue;
            this.userName = user.getAsJsonObject().get("Name").getAsString();
            this.uuid = uuid;
            this.type = user.getAsJsonObject().get("Type").getAsString();
        }
        if (this.userName.equals("")) {
            CCubesCore.logger.log(Level.INFO, "No custom rewards detected for the current user!");
            return;
        }
        try {
            userRewards = HTTPUtil.getWebFile("https://api.theprogrammingturkey.com/chance_cubes/custom_rewards/users/" + this.userName + ".json", new CustomEntry[0]);
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the custom list for " + this.userName + "!");
            CCubesCore.logger.log(Level.ERROR, e.getMessage());
            return;
        }
        for (Map.Entry reward : userRewards.getAsJsonObject().entrySet()) {
            this.customRewards.add(CustomRewardsLoader.instance.parseReward(reward).getKey());
        }
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ChanceCubeRegistry.INSTANCE.registerReward(CustomUserReward.this);
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Seems you have some custom Chance Cubes rewards " + CustomUserReward.this.userName + "...."));
                    player.func_145747_a((ITextComponent)new TextComponentString("Let the fun begin! >:)"));
                }
            }
        });
    }

    @Override
    public void trigger(final World world, final BlockPos pos, final EntityPlayer player) {
        if (!UsernameCache.getLastKnownUsername((UUID)this.uuid).equalsIgnoreCase(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Hey you aren't " + this.userName + "! You can't have their reward! Try again!"));
            EntityItem itemEnt = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)CCubesBlocks.CHANCE_CUBE, 1));
            world.func_72838_d((Entity)itemEnt);
            return;
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Selecting best (possibly deadly) reward for " + this.type + " " + this.userName));
        Scheduler.scheduleTask(new Task("Custom Reward", 100){

            @Override
            public void callback() {
                ((BasicReward)CustomUserReward.this.customRewards.get(world.field_73012_v.nextInt(CustomUserReward.this.customRewards.size()))).trigger(world, pos, player);
            }
        });
    }

    @Override
    public int getChanceValue() {
        return 0;
    }

    @Override
    public String getName() {
        return "chancecubes:CR_" + this.userName;
    }
}

