/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetwork;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;

public class FluidNetwork
extends PositionedAddonsNetwork
implements IFluidNetwork {
    protected IFluidHandler getFluidHandler(IPositionedAddonsNetwork.PrioritizedPartPos pos) {
        if (this.isPositionDisabled(pos.getPartPos())) {
            return null;
        }
        return (IFluidHandler)TileHelpers.getCapability((DimPos)pos.getPartPos().getPos(), (EnumFacing)pos.getPartPos().getSide(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    public boolean addPosition(PartPos pos, int priority) {
        IFluidHandler fluidHandler = (IFluidHandler)TileHelpers.getCapability((DimPos)pos.getPos(), (EnumFacing)pos.getSide(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        return fluidHandler != null && super.addPosition(pos, priority);
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList properties = Lists.newArrayList();
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.getPositions()) {
            IFluidHandler fluidHandler = this.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.disablePosition(partPos.getPartPos());
            properties.addAll(Lists.newArrayList((Object[])fluidHandler.getTankProperties()));
            this.enablePosition(partPos.getPartPos());
        }
        return properties.toArray(new IFluidTankProperties[properties.size()]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = FluidHelpers.getAmount((FluidStack)resource);
        int toFill = amount = Math.min(amount, GeneralConfig.fluidRateLimit);
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.getPositions()) {
            IFluidHandler fluidHandler = this.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.disablePosition(partPos.getPartPos());
            this.enablePosition(partPos.getPartPos());
            if ((toFill -= fluidHandler.fill(resource, doFill)) > 0) continue;
            break;
        }
        return amount - toFill;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int drained;
        resource = resource.copy();
        int maxDrain = FluidHelpers.getAmount((FluidStack)resource);
        maxDrain = Math.min(maxDrain, GeneralConfig.fluidRateLimit);
        Fluid fluid = null;
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.getPositions()) {
            IFluidHandler fluidHandler = this.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.disablePosition(partPos.getPartPos());
            FluidStack drainedFluid = fluidHandler.drain(resource, doDrain);
            this.enablePosition(partPos.getPartPos());
            resource.amount -= FluidHelpers.getAmount((FluidStack)drainedFluid);
            if (drainedFluid != null) {
                fluid = drainedFluid.getFluid();
            }
            if (resource.amount > 0) continue;
            break;
        }
        return (drained = maxDrain - resource.amount) <= 0 ? null : new FluidStack(fluid, drained);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int drained;
        int toDrain = maxDrain = Math.min(maxDrain, GeneralConfig.fluidRateLimit);
        Fluid fluid = null;
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.getPositions()) {
            IFluidHandler fluidHandler = this.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.disablePosition(partPos.getPartPos());
            FluidStack drainedFluid = fluidHandler.drain(toDrain, doDrain);
            this.enablePosition(partPos.getPartPos());
            toDrain -= FluidHelpers.getAmount((FluidStack)drainedFluid);
            if (drainedFluid != null) {
                fluid = drainedFluid.getFluid();
            }
            if (toDrain > 0) continue;
            break;
        }
        return (drained = maxDrain - toDrain) <= 0 ? null : new FluidStack(fluid, drained);
    }
}

