/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.autocrafting.AutoCraftingEvent;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.registry.ICraftingTaskFactory;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.grid.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageCache;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.NetworkNodeGraph;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.FluidGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.ItemGridHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemHandler;
import com.raoulvdberge.refinedstorage.apiimpl.storage.fluid.FluidStorageCache;
import com.raoulvdberge.refinedstorage.apiimpl.storage.item.ItemStorageCache;
import com.raoulvdberge.refinedstorage.block.BlockController;
import com.raoulvdberge.refinedstorage.block.EnumControllerType;
import com.raoulvdberge.refinedstorage.block.EnumGridType;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.container.ContainerReaderWriter;
import com.raoulvdberge.refinedstorage.integration.forgeenergy.ControllerEnergyForge;
import com.raoulvdberge.refinedstorage.integration.ic2.ControllerEnergyIC2;
import com.raoulvdberge.refinedstorage.integration.ic2.ControllerEnergyIC2None;
import com.raoulvdberge.refinedstorage.integration.ic2.IControllerEnergyIC2;
import com.raoulvdberge.refinedstorage.integration.ic2.IntegrationIC2;
import com.raoulvdberge.refinedstorage.integration.tesla.ControllerEnergyTesla;
import com.raoulvdberge.refinedstorage.integration.tesla.IntegrationTesla;
import com.raoulvdberge.refinedstorage.network.MessageCraftingMonitorElements;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidDelta;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidUpdate;
import com.raoulvdberge.refinedstorage.network.MessageGridItemDelta;
import com.raoulvdberge.refinedstorage.network.MessageGridItemUpdate;
import com.raoulvdberge.refinedstorage.network.MessageReaderWriterUpdate;
import com.raoulvdberge.refinedstorage.tile.ClientNode;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.RSSerializers;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.externalstorage.FluidStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageExternal;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileController
extends TileBase
implements INetworkMaster,
IEnergyReceiver,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer> REDSTONE_MODE = RedstoneMode.createParameter();
    public static final TileDataParameter<Integer> ENERGY_USAGE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergyUsage();
        }
    });
    public static final TileDataParameter<Integer> ENERGY_STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergy().getEnergyStored();
        }
    });
    public static final TileDataParameter<Integer> ENERGY_CAPACITY = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileController>(){

        @Override
        public Integer getValue(TileController tile) {
            return tile.getEnergy().getMaxEnergyStored();
        }
    });
    public static final TileDataParameter<List<ClientNode>> NODES = new TileDataParameter<List<ClientNode>>(RSSerializers.CLIENT_NODE_SERIALIZER, new ArrayList(), new ITileDataProducer<List<ClientNode>, TileController>(){

        @Override
        public List<ClientNode> getValue(TileController tile) {
            ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
            for (INetworkNode node : tile.nodeGraph.all()) {
                ClientNode clientNode;
                if (!node.canUpdate() || (clientNode = new ClientNode(node.getNodeItemStack(), 1, node.getEnergyUsage())).getStack().func_77973_b() == null) continue;
                if (nodes.contains(clientNode)) {
                    ClientNode other = (ClientNode)nodes.get(nodes.indexOf(clientNode));
                    other.setAmount(other.getAmount() + 1);
                    continue;
                }
                nodes.add(clientNode);
            }
            Collections.sort(nodes, CLIENT_NODE_COMPARATOR);
            return nodes;
        }
    });
    public static final String NBT_ENERGY = "Energy";
    public static final String NBT_ENERGY_CAPACITY = "EnergyCapacity";
    private static final String NBT_CRAFTING_TASKS = "CraftingTasks";
    private static final String NBT_READER_WRITER_CHANNELS = "ReaderWriterChannels";
    private static final String NBT_READER_WRITER_NAME = "Name";
    private static final Comparator<ClientNode> CLIENT_NODE_COMPARATOR = (left, right) -> {
        if (left.getEnergyUsage() == right.getEnergyUsage()) {
            return 0;
        }
        return left.getEnergyUsage() > right.getEnergyUsage() ? -1 : 1;
    };
    private static final Comparator<IStorage> STORAGE_COMPARATOR = (left, right) -> {
        int compare = Integer.compare(right.getPriority(), left.getPriority());
        return compare != 0 ? compare : Integer.compare(right.getStored(), left.getStored());
    };
    private IItemGridHandler itemGridHandler = new ItemGridHandler(this);
    private IFluidGridHandler fluidGridHandler = new FluidGridHandler(this);
    private INetworkItemHandler networkItemHandler = new NetworkItemHandler(this);
    private INetworkNodeGraph nodeGraph = new NetworkNodeGraph(this);
    private IItemStorageCache itemStorage = new ItemStorageCache(this);
    private IFluidStorageCache fluidStorage = new FluidStorageCache(this);
    private Map<String, IReaderWriterChannel> readerWriterChannels = new HashMap<String, IReaderWriterChannel>();
    private List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private List<ICraftingTask> craftingTasks = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToAdd = new ArrayList<ICraftingTask>();
    private List<ICraftingTask> craftingTasksToCancel = new ArrayList<ICraftingTask>();
    private List<NBTTagCompound> craftingTasksToRead = new ArrayList<NBTTagCompound>();
    private List<ICraftingStep> runningSteps = new ArrayList<ICraftingStep>();
    private EnergyStorage energy;
    private ControllerEnergyForge energyForge;
    private IControllerEnergyIC2 energyEU;
    private ControllerEnergyTesla energyTesla;
    private int lastEnergyDisplay;
    private boolean couldRun;
    private boolean craftingMonitorUpdateRequested;
    private EnumControllerType type;
    private RedstoneMode redstoneMode;

    public TileController() {
        this.energy = new EnergyStorage(RS.INSTANCE.config.controllerCapacity);
        this.energyForge = new ControllerEnergyForge(this);
        this.redstoneMode = RedstoneMode.IGNORE;
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_USAGE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addParameter(ENERGY_CAPACITY);
        this.dataManager.addParameter(NODES);
        this.energyEU = IntegrationIC2.isLoaded() ? new ControllerEnergyIC2(this) : new ControllerEnergyIC2None();
        if (IntegrationTesla.isLoaded()) {
            this.energyTesla = new ControllerEnergyTesla(this.energy);
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public EnergyStorage getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canRun() {
        return this.energy.getEnergyStored() > 0 && this.redstoneMode.isEnabled(this.func_145831_w(), this.field_174879_c);
    }

    @Override
    public INetworkNodeGraph getNodeGraph() {
        return this.nodeGraph;
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.energyEU.update();
            if (!this.craftingTasksToRead.isEmpty()) {
                for (NBTTagCompound tag : this.craftingTasksToRead) {
                    ICraftingTask task = TileController.readCraftingTask(this.func_145831_w(), this, tag);
                    if (task == null) continue;
                    this.addCraftingTask(task);
                }
                this.craftingTasksToRead.clear();
            }
            if (this.canRun()) {
                Collections.sort(this.itemStorage.getStorages(), STORAGE_COMPARATOR);
                Collections.sort(this.fluidStorage.getStorages(), STORAGE_COMPARATOR);
                boolean craftingTasksChanged = !this.craftingTasksToAdd.isEmpty() || !this.craftingTasksToCancel.isEmpty();
                this.craftingTasksToCancel.forEach(ICraftingTask::onCancelled);
                this.craftingTasks.removeAll(this.craftingTasksToCancel);
                this.craftingTasksToCancel.clear();
                this.craftingTasksToAdd.stream().filter(ICraftingTask::isValid).forEach(this.craftingTasks::add);
                this.craftingTasksToAdd.clear();
                if (this.ticks % 5 == 0) {
                    Iterator<ICraftingTask> craftingTaskIterator = this.craftingTasks.iterator();
                    HashMap<ICraftingPatternContainer, Integer> usedCrafters = new HashMap<ICraftingPatternContainer, Integer>();
                    while (craftingTaskIterator.hasNext()) {
                        ICraftingTask task = craftingTaskIterator.next();
                        if (task.update(usedCrafters)) {
                            AutoCraftingEvent.fire(this, task.getRequested(), task.getQuantity());
                            craftingTaskIterator.remove();
                            craftingTasksChanged = true;
                            continue;
                        }
                        if (task.getMissing().isEmpty() || this.ticks % 100 != 0 || !(Math.random() > 0.5)) continue;
                        task.getMissing().clear();
                    }
                    this.runningSteps = this.craftingTasks.stream().map(ICraftingTask::getSteps).flatMap(Collection::stream).filter(ICraftingStep::hasStartedProcessing).collect(Collectors.toList());
                    if (craftingTasksChanged) {
                        this.craftingMonitorUpdateRequested = true;
                    }
                }
                for (IReaderWriterChannel channel : this.readerWriterChannels.values()) {
                    for (IReaderWriterHandler handler : channel.getHandlers()) {
                        handler.update(channel);
                    }
                }
                if (!this.craftingTasks.isEmpty() || !this.readerWriterChannels.isEmpty()) {
                    this.func_70296_d();
                }
                if (this.craftingMonitorUpdateRequested) {
                    this.craftingMonitorUpdateRequested = false;
                    this.sendCraftingMonitorUpdate();
                }
            }
            this.networkItemHandler.update();
            if (this.getType() == EnumControllerType.NORMAL) {
                if (!RS.INSTANCE.config.controllerUsesEnergy) {
                    this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
                } else if (this.energy.getEnergyStored() - this.getEnergyUsage() >= 0) {
                    this.energy.extractEnergy(this.getEnergyUsage(), false);
                } else {
                    this.energy.setEnergyStored(0);
                }
            } else if (this.getType() == EnumControllerType.CREATIVE) {
                this.energy.setEnergyStored(this.energy.getMaxEnergyStored());
            }
            if (this.couldRun != this.canRun()) {
                this.couldRun = this.canRun();
                this.nodeGraph.rebuild();
            }
            if (this.getEnergyScaledForDisplay() != this.lastEnergyDisplay) {
                this.lastEnergyDisplay = this.getEnergyScaledForDisplay();
                this.updateBlock();
            }
        }
        super.func_73660_a();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energyEU.invalidate();
    }

    @Override
    public IItemGridHandler getItemGridHandler() {
        return this.itemGridHandler;
    }

    @Override
    public IFluidGridHandler getFluidGridHandler() {
        return this.fluidGridHandler;
    }

    @Override
    public INetworkItemHandler getNetworkItemHandler() {
        return this.networkItemHandler;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.energyEU.onChunkUnload();
    }

    public void onDestroyed() {
        this.nodeGraph.disconnectAll();
    }

    @Override
    public IItemStorageCache getItemStorageCache() {
        return this.itemStorage;
    }

    @Override
    public IFluidStorageCache getFluidStorageCache() {
        return this.fluidStorage;
    }

    @Override
    public List<ICraftingTask> getCraftingTasks() {
        return this.craftingTasks;
    }

    @Override
    public void addCraftingTask(ICraftingTask task) {
        this.craftingTasksToAdd.add(task);
        this.func_70296_d();
    }

    @Override
    public void cancelCraftingTask(ICraftingTask task) {
        this.craftingTasksToCancel.add(task);
        this.func_70296_d();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public List<ICraftingPattern> getPatterns(ItemStack pattern, int flags) {
        ArrayList<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
        for (ICraftingPattern craftingPattern : this.getPatterns()) {
            for (ItemStack output : craftingPattern.getOutputs()) {
                if (!API.instance().getComparer().isEqual(output, pattern, flags)) continue;
                patterns.add(craftingPattern);
            }
        }
        return patterns;
    }

    @Override
    public ICraftingPattern getPattern(ItemStack pattern, int flags) {
        return this.getPattern(pattern, flags, this.itemStorage.getList().getOredicted());
    }

    @Override
    public ICraftingPattern getPattern(ItemStack pattern, int flags, IItemStackList itemList) {
        List<ICraftingPattern> patterns = this.getPatterns(pattern, flags);
        if (patterns.isEmpty()) {
            return null;
        }
        if (patterns.size() == 1) {
            return patterns.get(0);
        }
        int highestScore = 0;
        int highestPattern = 0;
        for (int i = 0; i < patterns.size(); ++i) {
            int score = 0;
            for (ItemStack input : patterns.get(i).getInputs()) {
                if (input == null) continue;
                ItemStack stored = itemList.get(input, 3 | (patterns.get(i).isOredict() ? 8 : 0));
                score += stored != null ? stored.field_77994_a : 0;
            }
            if (score <= highestScore) continue;
            highestScore = score;
            highestPattern = i;
        }
        return patterns.get(highestPattern);
    }

    @Override
    public void scheduleCraftingTask(ItemStack stack, int toSchedule, int compare) {
        ICraftingPattern pattern;
        for (ICraftingTask task : this.getCraftingTasks()) {
            for (ItemStack output : task.getPattern().getOutputs()) {
                if (!API.instance().getComparer().isEqual(output, stack, compare)) continue;
                toSchedule -= output.field_77994_a * task.getQuantity();
            }
        }
        if (toSchedule > 0 && (pattern = this.getPattern(stack, compare)) != null) {
            ICraftingTask task;
            task = this.createCraftingTask(stack, pattern, toSchedule);
            task.calculate();
            task.getMissing().clear();
            this.addCraftingTask(task);
            this.markCraftingMonitorForUpdate();
        }
    }

    @Override
    public void rebuildPatterns() {
        this.patterns.clear();
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!(node instanceof ICraftingPatternContainer) || !node.canUpdate()) continue;
            this.patterns.addAll(((ICraftingPatternContainer)((Object)node)).getPatterns());
        }
        this.itemStorage.invalidate();
    }

    @Override
    public void sendItemStorageToClient() {
        this.func_145831_w().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.NORMAL, EnumGridType.CRAFTING, EnumGridType.PATTERN)).forEach(this::sendItemStorageToClient);
    }

    @Override
    public void sendItemStorageToClient(EntityPlayerMP player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemUpdate(this), player);
    }

    @Override
    public void sendItemStorageDeltaToClient(ItemStack stack, int delta) {
        this.func_145831_w().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.NORMAL, EnumGridType.CRAFTING, EnumGridType.PATTERN)).forEach(player -> RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemDelta(this, stack, delta), player));
    }

    @Override
    public void sendFluidStorageToClient() {
        this.func_145831_w().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.FLUID)).forEach(this::sendFluidStorageToClient);
    }

    @Override
    public void sendFluidStorageToClient(EntityPlayerMP player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridFluidUpdate(this), player);
    }

    @Override
    public void sendFluidStorageDeltaToClient(FluidStack stack, int delta) {
        this.func_145831_w().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> this.isWatchingGrid((EntityPlayer)player, EnumGridType.FLUID)).forEach(player -> RS.INSTANCE.network.sendTo((IMessage)new MessageGridFluidDelta(stack, delta), player));
    }

    private boolean isWatchingGrid(EntityPlayer player, EnumGridType ... types) {
        IGrid grid;
        if (player.field_71070_bA.getClass() == ContainerGrid.class && this.field_174879_c.equals((Object)(grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getNetworkPosition())) {
            return Arrays.asList(types).contains((Object)grid.getType());
        }
        return false;
    }

    @Override
    public void markCraftingMonitorForUpdate() {
        this.craftingMonitorUpdateRequested = true;
    }

    @Override
    public void sendCraftingMonitorUpdate() {
        List<EntityPlayerMP> watchers = this.func_145831_w().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> player.field_71070_bA instanceof ContainerCraftingMonitor && this.field_174879_c.equals((Object)((ContainerCraftingMonitor)player.field_71070_bA).getCraftingMonitor().getNetworkPosition())).collect(Collectors.toList());
        if (!watchers.isEmpty()) {
            List<ICraftingMonitorElement> elements = this.getElements();
            watchers.forEach(player -> RS.INSTANCE.network.sendTo((IMessage)new MessageCraftingMonitorElements(elements), player));
        }
    }

    @Override
    public void sendCraftingMonitorUpdate(EntityPlayerMP player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageCraftingMonitorElements(this.getElements()), player);
    }

    @Override
    @Nullable
    public IReaderWriterChannel getReaderWriterChannel(String name) {
        return this.readerWriterChannels.get(name);
    }

    @Override
    public void addReaderWriterChannel(String name) {
        this.readerWriterChannels.put(name, API.instance().createReaderWriterChannel(name, this));
        this.sendReaderWriterChannelUpdate();
    }

    @Override
    public void removeReaderWriterChannel(String name) {
        IReaderWriterChannel channel = this.getReaderWriterChannel(name);
        if (channel != null) {
            channel.getReaders().forEach(reader -> reader.setChannel(""));
            channel.getWriters().forEach(writer -> writer.setChannel(""));
            this.readerWriterChannels.remove(name);
            this.sendReaderWriterChannelUpdate();
        }
    }

    @Override
    public void sendReaderWriterChannelUpdate() {
        this.func_145831_w().func_73046_m().func_184103_al().func_181057_v().stream().filter(player -> player.field_71070_bA instanceof ContainerReaderWriter && ((ContainerReaderWriter)player.field_71070_bA).getReaderWriter().isConnected() && this.field_174879_c.equals((Object)((ContainerReaderWriter)player.field_71070_bA).getReaderWriter().getNetwork().getPosition())).forEach(this::sendReaderWriterChannelUpdate);
    }

    @Override
    public void sendReaderWriterChannelUpdate(EntityPlayerMP player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageReaderWriterUpdate(this.readerWriterChannels.keySet()), player);
    }

    private List<ICraftingMonitorElement> getElements() {
        return this.craftingTasks.stream().flatMap(t -> t.getCraftingMonitorElements().stream()).collect(Collectors.toList());
    }

    @Override
    public ItemStack insertItem(@Nonnull ItemStack stack, int size, boolean simulate) {
        int inserted;
        if (stack == null || stack.func_77973_b() == null || this.itemStorage.getStorages().isEmpty()) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        int orginalSize = size;
        ItemStack remainder = stack;
        int externalStorageInserted = 0;
        int insertOnlyInserted = 0;
        for (IItemStorage storage : this.itemStorage.getStorages()) {
            if (storage.getAccessType() != AccessType.EXTRACT) {
                remainder = storage.insertItem(remainder, size, simulate);
                if (storage.getAccessType() == AccessType.INSERT && !simulate) {
                    insertOnlyInserted += size - (remainder != null ? remainder.field_77994_a : 0);
                }
            }
            if (remainder == null || remainder.field_77994_a <= 0) {
                if (!(storage instanceof ItemStorageExternal) || simulate) break;
                ((ItemStorageExternal)storage).detectChanges(this);
                externalStorageInserted += size;
                break;
            }
            if (size != remainder.field_77994_a && storage instanceof ItemStorageExternal && !simulate) {
                ((ItemStorageExternal)storage).detectChanges(this);
                externalStorageInserted += size - remainder.field_77994_a;
            }
            size = remainder.field_77994_a;
        }
        if (remainder == null) {
            inserted = orginalSize;
        } else if (remainder.field_77994_a < 0) {
            inserted = orginalSize + remainder.field_77994_a;
            remainder = null;
        } else {
            inserted = orginalSize - remainder.field_77994_a;
        }
        if (!simulate) {
            if (inserted - externalStorageInserted - insertOnlyInserted > 0) {
                this.itemStorage.add(stack, inserted - externalStorageInserted - insertOnlyInserted, false);
            }
            if (inserted > 0) {
                ItemStack checkSteps = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)inserted);
                for (ICraftingStep step : this.runningSteps) {
                    if (!step.onReceiveOutput(checkSteps)) continue;
                    return remainder;
                }
            }
        }
        return remainder;
    }

    @Override
    public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        int requested = size;
        int received = 0;
        int externalStorageExtracted = 0;
        ItemStack newStack = null;
        for (IItemStorage storage : this.itemStorage.getStorages()) {
            ItemStack took = null;
            if (storage.getAccessType() != AccessType.INSERT) {
                took = storage.extractItem(stack, requested - received, flags, simulate);
            }
            if (took != null) {
                if (storage instanceof ItemStorageExternal && !simulate) {
                    ((ItemStorageExternal)storage).detectChanges(this);
                    externalStorageExtracted += took.field_77994_a;
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.field_77994_a += took.field_77994_a;
                }
                received += took.field_77994_a;
            }
            if (requested != received) continue;
            break;
        }
        if (newStack != null && newStack.field_77994_a - externalStorageExtracted > 0 && !simulate) {
            this.itemStorage.remove(newStack, newStack.field_77994_a - externalStorageExtracted);
        }
        return newStack;
    }

    @Override
    @Nullable
    public FluidStack insertFluid(@Nonnull FluidStack stack, int size, boolean simulate) {
        int inserted;
        if (stack == null || this.fluidStorage.getStorages().isEmpty()) {
            return RSUtils.copyStackWithSize(stack, size);
        }
        int orginalSize = size;
        AccessType accessType = AccessType.INSERT_EXTRACT;
        FluidStack remainder = stack;
        for (IFluidStorage storage : this.fluidStorage.getStorages()) {
            accessType = storage.getAccessType();
            if (accessType != AccessType.EXTRACT) {
                remainder = storage.insertFluid(remainder, size, simulate);
            }
            if (storage instanceof FluidStorageExternal && !simulate) {
                ((FluidStorageExternal)storage).updateCacheForcefully();
            }
            if (remainder == null || remainder.amount <= 0) break;
            size = remainder.amount;
        }
        if (remainder == null) {
            inserted = orginalSize;
        } else if (remainder.amount < 0) {
            inserted = orginalSize + remainder.amount;
            remainder = null;
        } else {
            inserted = orginalSize - remainder.amount;
        }
        if (!simulate && inserted > 0 && accessType != AccessType.INSERT) {
            this.fluidStorage.add(RSUtils.copyStackWithSize(stack, inserted), false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public FluidStack extractFluid(@Nonnull FluidStack stack, int size, int flags, boolean simulate) {
        int requested = size;
        int received = 0;
        FluidStack newStack = null;
        for (IFluidStorage storage : this.fluidStorage.getStorages()) {
            FluidStack took = null;
            if (storage.getAccessType() != AccessType.INSERT) {
                took = storage.extractFluid(stack, requested - received, flags, simulate);
            }
            if (took != null) {
                if (storage instanceof FluidStorageExternal && !simulate) {
                    ((FluidStorageExternal)storage).updateCacheForcefully();
                }
                if (newStack == null) {
                    newStack = took;
                } else {
                    newStack.amount += took.amount;
                }
                received += took.amount;
            }
            if (requested != received) continue;
            break;
        }
        if (newStack != null && !simulate) {
            this.fluidStorage.remove(newStack);
        }
        return newStack;
    }

    @Override
    public World getNetworkWorld() {
        return this.func_145831_w();
    }

    private static ICraftingTask readCraftingTask(World world, INetworkMaster network, NBTTagCompound tag) {
        TileEntity container;
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("PatternStack"));
        if (stack != null && stack.func_77973_b() instanceof ICraftingPatternProvider && (container = world.func_175625_s(BlockPos.func_177969_a((long)tag.func_74763_f("PatternContainer")))) instanceof ICraftingPatternContainer) {
            ICraftingPattern pattern = ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, (ICraftingPatternContainer)container);
            ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().getFactory(tag.func_74779_i("PatternID"));
            if (factory != null) {
                return factory.create(world, network, tag.func_74764_b("Requested") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Requested")) : null, pattern, tag.func_74762_e("Quantity"), tag);
            }
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.redstoneMode = RedstoneMode.read(tag);
        if (tag.func_74764_b(NBT_CRAFTING_TASKS)) {
            NBTTagList taskList = tag.func_150295_c(NBT_CRAFTING_TASKS, 10);
            for (i = 0; i < taskList.func_74745_c(); ++i) {
                this.craftingTasksToRead.add(taskList.func_150305_b(i));
            }
        }
        if (tag.func_74764_b(NBT_READER_WRITER_CHANNELS)) {
            NBTTagList readerWriterChannelsList = tag.func_150295_c(NBT_READER_WRITER_CHANNELS, 10);
            for (i = 0; i < readerWriterChannelsList.func_74745_c(); ++i) {
                NBTTagCompound channelTag = readerWriterChannelsList.func_150305_b(i);
                String name = channelTag.func_74779_i(NBT_READER_WRITER_NAME);
                IReaderWriterChannel channel = API.instance().createReaderWriterChannel(name, this);
                channel.readFromNBT(channelTag);
                this.readerWriterChannels.put(name, channel);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        this.redstoneMode.write(tag);
        NBTTagList craftingTaskList = new NBTTagList();
        for (ICraftingTask task : this.craftingTasks) {
            craftingTaskList.func_74742_a((NBTBase)task.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_CRAFTING_TASKS, (NBTBase)craftingTaskList);
        NBTTagList readerWriterChannelsList = new NBTTagList();
        for (Map.Entry<String, IReaderWriterChannel> entry : this.readerWriterChannels.entrySet()) {
            NBTTagCompound channelTag = entry.getValue().writeToNBT(new NBTTagCompound());
            channelTag.func_74778_a(NBT_READER_WRITER_NAME, entry.getKey());
            readerWriterChannelsList.func_74742_a((NBTBase)channelTag);
        }
        tag.func_74782_a(NBT_READER_WRITER_CHANNELS, (NBTBase)readerWriterChannelsList);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_ENERGY_CAPACITY, this.energy.getMaxEnergyStored());
        tag.func_74768_a(NBT_ENERGY, this.energy.getEnergyStored());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.energy.setCapacity(tag.func_74762_e(NBT_ENERGY_CAPACITY));
        this.energy.setEnergyStored(tag.func_74762_e(NBT_ENERGY));
        super.readUpdate(tag);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    public static int getEnergyScaled(int stored, int capacity, int scale) {
        return (int)((float)stored / (float)capacity * (float)scale);
    }

    public int getEnergyScaledForDisplay() {
        return TileController.getEnergyScaled(this.energy.getEnergyStored(), this.energy.getMaxEnergyStored(), 7);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.INSTANCE.config.controllerBaseUsage;
        for (INetworkNode node : this.nodeGraph.all()) {
            if (!node.canUpdate()) continue;
            usage += node.getEnergyUsage();
        }
        return usage;
    }

    public EnumControllerType getType() {
        if (this.type == null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == RSBlocks.CONTROLLER) {
            this.type = (EnumControllerType)((Object)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockController.TYPE));
        }
        return this.type == null ? EnumControllerType.NORMAL : this.type;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyForge;
        }
        if (this.energyTesla != null && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER)) {
            return (T)this.energyTesla;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || this.energyTesla != null && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER) || super.hasCapability(capability, facing);
    }
}

