/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.container.ContainerProcessingPatternEncoder;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageProcessingPatternEncoderTransfer
extends MessageHandlerPlayerToServer<MessageProcessingPatternEncoderTransfer>
implements IMessage {
    private Collection<ItemStack> inputs;
    private Collection<ItemStack> outputs;

    public MessageProcessingPatternEncoderTransfer() {
    }

    public MessageProcessingPatternEncoderTransfer(Collection<ItemStack> inputs, Collection<ItemStack> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.inputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.inputs.add(RSUtils.readItemStack(buf));
        }
        size = buf.readInt();
        this.outputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.outputs.add(RSUtils.readItemStack(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inputs.size());
        for (ItemStack stack : this.inputs) {
            RSUtils.writeItemStack(buf, stack);
        }
        buf.writeInt(this.outputs.size());
        for (ItemStack stack : this.outputs) {
            RSUtils.writeItemStack(buf, stack);
        }
    }

    @Override
    public void handle(MessageProcessingPatternEncoderTransfer message, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerProcessingPatternEncoder) {
            ContainerProcessingPatternEncoder encoder = (ContainerProcessingPatternEncoder)player.field_71070_bA;
            encoder.clearInputsAndOutputs();
            encoder.setInputs(message.inputs);
            encoder.setOutputs(message.outputs);
        }
    }
}

