/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.tile.IReaderWriter;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ReaderWriterHandlerFluids
implements IReaderWriterHandler {
    public static final String ID = "fluids";
    private FluidTank tank = new FluidTank(4000);
    private FluidTankReaderWriter tankReader = new FluidTankReaderWriter(this.tank, true, false);
    private FluidTankReaderWriter tankWriter = new FluidTankReaderWriter(this.tank, false, true);

    public ReaderWriterHandlerFluids(@Nullable NBTTagCompound tag) {
        if (tag != null) {
            this.tank.readFromNBT(tag);
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapability(IReaderWriter readerWriter, Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (readerWriter instanceof IReader || readerWriter instanceof IWriter);
    }

    @Override
    public <T> T getCapability(IReaderWriter readerWriter, Capability<T> capability) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (readerWriter instanceof IReader) {
                return (T)this.tankReader;
            }
            if (readerWriter instanceof IWriter) {
                return (T)this.tankWriter;
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    private class FluidTankReaderWriter
    implements IFluidTank,
    IFluidHandler {
        private FluidTank parent;
        private boolean canFill;
        private boolean canDrain;
        private IFluidTankProperties[] properties;

        public FluidTankReaderWriter(final FluidTank parent, final boolean canFill, final boolean canDrain) {
            this.parent = parent;
            this.canFill = canFill;
            this.canDrain = canDrain;
            this.properties = new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return parent.getFluid();
                }

                public int getCapacity() {
                    return parent.getCapacity();
                }

                public boolean canFill() {
                    return canFill;
                }

                public boolean canDrain() {
                    return canDrain;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return canFill;
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return canDrain;
                }
            }};
        }

        @Nullable
        public FluidStack getFluid() {
            return this.parent.getFluid();
        }

        public int getFluidAmount() {
            return this.parent.getFluidAmount();
        }

        public int getCapacity() {
            return this.parent.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.parent.getInfo();
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.canFill ? this.parent.fill(resource, doFill) : 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.canDrain ? this.parent.drain(resource, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.canDrain ? this.parent.drain(maxDrain, doDrain) : null;
        }
    }
}

