/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStep;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingStepProcess
extends CraftingStep {
    public static final String ID = "process";

    public CraftingStepProcess(INetworkMaster network, ICraftingPattern pattern, List<ICraftingStep> preliminarySteps) {
        super(network, pattern, preliminarySteps);
    }

    public CraftingStepProcess(INetworkMaster network) {
        super(network);
    }

    @Override
    public boolean canStartProcessing(IItemStackList items, IFluidStackList fluids) {
        if (!super.canStartProcessing()) {
            return false;
        }
        IItemHandler inventory = this.getPattern().getContainer().getFacingInventory();
        int compare = 0x13 | (this.pattern.isOredict() ? 8 : 0);
        if (inventory != null) {
            LinkedList<ItemStack> toInsert = new LinkedList<ItemStack>();
            for (ItemStack stack : this.getToInsert()) {
                compare = stack.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
                ItemStack actualStack = items.get(stack, compare);
                CraftingStep.AvailableType type = this.isItemAvailable(items, fluids, stack, actualStack, compare);
                if (type == CraftingStep.AvailableType.ITEM) {
                    toInsert.add(ItemHandlerHelper.copyStackWithSize((ItemStack)actualStack, (int)stack.field_77994_a));
                    continue;
                }
                if (type == CraftingStep.AvailableType.FLUID) {
                    toInsert.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.field_77994_a));
                    continue;
                }
                items.undo();
                fluids.undo();
                return false;
            }
            items.undo();
            fluids.undo();
            return CraftingStepProcess.insert(inventory, toInsert, true);
        }
        return false;
    }

    @Override
    public boolean canStartProcessing() {
        if (!super.canStartProcessing()) {
            return false;
        }
        IItemHandler inventory = this.getPattern().getContainer().getFacingInventory();
        return inventory != null && CraftingStepProcess.insert(inventory, new LinkedList<ItemStack>(this.getToInsert()), true);
    }

    @Override
    public void execute(Deque<ItemStack> toInsertItems, Deque<FluidStack> toInsertFluids) {
        LinkedList<ItemStack> actualInputs = new LinkedList<ItemStack>();
        int compare = 0x13 | (this.getPattern().isOredict() ? 8 : 0);
        if (this.extractItems(actualInputs, compare, toInsertItems)) {
            IItemHandler inventory = this.getPattern().getContainer().getFacingInventory();
            if (CraftingStepProcess.insert(inventory, new ArrayDeque<ItemStack>(actualInputs), true)) {
                CraftingStepProcess.insert(inventory, actualInputs, false);
            } else {
                toInsertItems.addAll(actualInputs);
                this.startedProcessing = false;
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("CraftingStepType", ID);
        return super.writeToNBT(tag);
    }

    private static boolean insert(IItemHandler dest, Deque<ItemStack> stacks, boolean simulate) {
        ItemStack current = stacks.poll();
        List availableSlots = IntStream.range(0, dest.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = null;
            for (Integer slot : availableSlots) {
                remainder = dest.insertItem(slot.intValue(), current, simulate);
                if (remainder != null && current.field_77994_a == remainder.field_77994_a) continue;
                availableSlots.remove(slot);
                break;
            }
            if (remainder == null || remainder.field_77994_a <= 0) {
                current = stacks.poll();
                continue;
            }
            if (current.field_77994_a == remainder.field_77994_a) break;
            current = remainder;
        }
        return current == null && stacks.isEmpty();
    }
}

