/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.IngredientInformation;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.compat.IJEIRecipeRegistry;
import minetweaker.api.item.IIngredient;
import minetweaker.mc1102.util.MineTweakerHacks;
import minetweaker.mods.jei.JEIAddonPlugin;
import minetweaker.util.IEventHandler;
import net.minecraft.item.ItemStack;

public class JEIRecipeRegistry
implements IJEIRecipeRegistry {
    private IRecipeRegistry recipeRegistry;
    private IJeiHelpers jeiHelpers;
    private boolean shouldReloadItemList = false;
    private static Map<Object, String> TOOLTIP_CACHE;

    public JEIRecipeRegistry(IRecipeRegistry recipeRegistry, IJeiHelpers jeiHelpers) {
        this.recipeRegistry = recipeRegistry;
        this.jeiHelpers = jeiHelpers;
        MineTweakerImplementationAPI.onPostReload(new ReloadHandler());
    }

    @Override
    public void addRecipe(Object object) {
        this.recipeRegistry.addRecipe(object);
    }

    @Override
    @Deprecated
    public void addRecipe(Object object, String category) {
        this.recipeRegistry.addRecipe(object);
    }

    @Override
    public void removeRecipe(Object object) {
        this.recipeRegistry.removeRecipe(object);
    }

    @Override
    @Deprecated
    public void removeRecipe(Object output, String category) {
        this.recipeRegistry.removeRecipe(output);
    }

    @Override
    public void addFurnace(List<Object> input, Object output) {
        ArrayList inputs = new ArrayList();
        input.forEach(in -> inputs.add((ItemStack)in));
        this.recipeRegistry.addSmeltingRecipe(inputs, (ItemStack)output);
    }

    @Override
    public void removeFurnace(Object object) {
        IFocus focus = this.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)((ItemStack)object));
        List categories = this.recipeRegistry.getRecipeCategories(focus);
        for (IRecipeCategory category : categories) {
            if (!category.getUid().equals("minecraft.smelting")) continue;
            List wrappers = this.recipeRegistry.getRecipeWrappers(category, focus);
            for (IRecipeWrapper wrapper : wrappers) {
                this.recipeRegistry.removeRecipe((Object)wrapper);
            }
        }
    }

    @Override
    public void addFuel(Collection<Object> input, int burnTime) {
        ArrayList inputs = new ArrayList();
        input.forEach(in -> inputs.add((ItemStack)in));
        this.recipeRegistry.addRecipe((Object)new FuelRecipe(this.jeiHelpers.getGuiHelper(), inputs, burnTime));
    }

    @Override
    public void removeFuel(Object object) {
        IFocus focus = this.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)((ItemStack)object));
        List categories = this.recipeRegistry.getRecipeCategories(focus);
        for (IRecipeCategory category : categories) {
            if (!category.getUid().equals("minecraft.fuel")) continue;
            List wrappers = this.recipeRegistry.getRecipeWrappers(category, focus);
            for (IRecipeWrapper wrapper : wrappers) {
                this.recipeRegistry.removeRecipe((Object)wrapper);
            }
        }
    }

    @Override
    public void reloadItemList() {
        this.shouldReloadItemList = true;
    }

    @Override
    public void removeItem(Object stack) {
    }

    @Override
    public void addItem(Object stack) {
    }

    @Override
    public void invalidateTooltips(IIngredient unused) {
        if (TOOLTIP_CACHE == null) {
            TOOLTIP_CACHE = (Map)MineTweakerHacks.getPrivateStaticObject(IngredientInformation.class, "tooltipCache");
        }
        if (TOOLTIP_CACHE != null) {
            TOOLTIP_CACHE.clear();
            this.reloadItemList();
        }
    }

    private class ReloadHandler
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        private ReloadHandler() {
        }

        @Override
        public void handle(MineTweakerImplementationAPI.ReloadEvent event) {
            if (JEIRecipeRegistry.this.shouldReloadItemList) {
                JEIRecipeRegistry.this.shouldReloadItemList = false;
                ((ItemListOverlay)JEIAddonPlugin.itemListOverlay).rebuildItemFilter();
            }
        }
    }
}

