/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistryDefaultHandler;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ForestryAddon {
    private static final String KEY_SAPLINGS = "Forestry Saplings";

    public ForestryAddon() {
        MarketRegistry.registerDefaultHandler(KEY_SAPLINGS, new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                for (ITree tree : TreeManager.treeRoot.getIndividualTemplates()) {
                    ItemStack saplingStack = TreeManager.treeRoot.getMemberStack((IIndividual)tree, (ISpeciesType)EnumGermlingType.SAPLING);
                    registry.registerEntry(saplingStack, defaultPayment, MarketEntry.EntryType.SAPLINGS);
                }
            }

            @Override
            public boolean isEnabledByDefault() {
                return false;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC, 2);
            }
        });
    }
}

