/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.rf;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.TileHelpers;

public class EnergyStorageRf
implements IEnergyStorage {
    private final IBlockAccess world;
    private final BlockPos pos;
    private final EnumFacing facing;
    private IEnergyHandler energyStorage = null;
    private IEnergyReceiver energyReceiver = null;
    private IEnergyProvider energyProvider = null;

    public EnergyStorageRf(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        this.world = world;
        this.pos = pos;
        this.facing = facing;
    }

    protected IEnergyHandler getEnergyStorage() {
        if (this.energyStorage != null) {
            return this.energyStorage;
        }
        this.energyStorage = (IEnergyHandler)TileHelpers.getSafeTile((IBlockAccess)this.world, (BlockPos)this.pos, IEnergyHandler.class);
        return this.energyStorage;
    }

    protected IEnergyReceiver getEnergyReceiver() {
        if (this.energyReceiver != null) {
            return this.energyReceiver;
        }
        this.energyReceiver = (IEnergyReceiver)TileHelpers.getSafeTile((IBlockAccess)this.world, (BlockPos)this.pos, IEnergyReceiver.class);
        return this.energyReceiver;
    }

    protected IEnergyProvider getEnergyProvider() {
        if (this.energyProvider != null) {
            return this.energyProvider;
        }
        this.energyProvider = (IEnergyProvider)TileHelpers.getSafeTile((IBlockAccess)this.world, (BlockPos)this.pos, IEnergyProvider.class);
        return this.energyProvider;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        IEnergyReceiver energyReceiver = this.getEnergyReceiver();
        return energyReceiver != null ? energyReceiver.receiveEnergy(this.facing, maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        IEnergyProvider energyProvider = this.getEnergyProvider();
        return energyProvider != null ? energyProvider.extractEnergy(this.facing, maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        IEnergyHandler energyStorage = this.getEnergyStorage();
        return energyStorage.getEnergyStored(this.facing);
    }

    public int getMaxEnergyStored() {
        IEnergyHandler energyStorage = this.getEnergyStorage();
        return energyStorage.getMaxEnergyStored(this.facing);
    }

    public boolean canExtract() {
        return this.getEnergyProvider() != null;
    }

    public boolean canReceive() {
        return this.getEnergyReceiver() != null;
    }
}

