/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.test;

import java.util.Objects;
import org.apache.http.util.Asserts;
import org.cyclops.integrateddynamics.command.CommandTest;

public class TestHelpers {
    public static boolean canRunIntegrationTests() {
        try {
            Class.forName(CommandTest.CLASSES.get(0));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> void assertEqual(T actual, T expected, String ifEqual) {
        try {
            if (actual instanceof Double) {
                Asserts.check(((Double)actual - (Double)expected < 1.0E-4 ? 1 : 0) != 0, (String)ifEqual);
            } else if (actual instanceof Float) {
                Asserts.check((((Float)actual).floatValue() - ((Float)expected).floatValue() < 1.0E-4f ? 1 : 0) != 0, (String)ifEqual);
            } else {
                Asserts.check((boolean)Objects.equals(actual, expected), (String)ifEqual);
            }
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)String.format("Failure: %s. Expected %s, but got %s.", ifEqual, expected, actual));
        }
    }
}

