/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class ItemBlockEnergyContainerCombinationRecipe
implements IRecipe {
    private final int size;
    private final ItemBlockEnergyContainer batteryItem;
    private final int maxCapacity;

    public ItemBlockEnergyContainerCombinationRecipe(int size, ItemBlockEnergyContainer batteryItem, int maxCapacity) {
        this.size = size;
        this.batteryItem = batteryItem;
        this.maxCapacity = maxCapacity;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return this.func_77572_b(grid) != null;
    }

    public int func_77570_a() {
        return this.size;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)BlockEnergyBattery.getInstance());
    }

    public ItemStack[] func_179532_b(InventoryCrafting inventory) {
        ItemStack[] aitemstack = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        IEnergyStorageCapacity energyStorage = (IEnergyStorageCapacity)output.getCapability(CapabilityEnergy.ENERGY, null);
        int totalCapacity = 0;
        int totalEnergy = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack element = grid.func_70301_a(j);
            if (element == null) continue;
            if (element.func_77973_b() == this.batteryItem) {
                IEnergyStorageCapacity currentEnergyStorage = (IEnergyStorageCapacity)element.getCapability(CapabilityEnergy.ENERGY, null);
                ++inputItems;
                totalEnergy = Helpers.addSafe((int)totalEnergy, (int)currentEnergyStorage.getEnergyStored());
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)currentEnergyStorage.getMaxEnergyStored());
                continue;
            }
            return null;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return null;
        }
        energyStorage.setCapacity(totalCapacity);
        energyStorage.receiveEnergy(totalEnergy, false);
        return output;
    }
}

