/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.core.network.diagnostics.IRawData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;

public class RawNetworkData
implements IRawData {
    private final boolean killed;
    private final int id;
    private final int cables;
    private final List<RawPartData> parts;

    public String toString() {
        return String.format("Network %s (cables: %s; elements: %s)", this.id, this.cables, this.parts.size());
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("killed", this.killed);
        tag.func_74768_a("id", this.id);
        tag.func_74772_a("cables", (long)this.cables);
        NBTTagList list = new NBTTagList();
        for (RawPartData part : this.parts) {
            list.func_74742_a((NBTBase)part.toNbt());
        }
        tag.func_74782_a("parts", (NBTBase)list);
        return tag;
    }

    public static RawNetworkData fromNbt(NBTTagCompound tag) {
        ArrayList parts = Lists.newArrayList();
        NBTTagList list = tag.func_150295_c("parts", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound partTag = list.func_150305_b(i);
            parts.add(RawPartData.fromNbt(partTag));
        }
        return new RawNetworkData(tag.func_74767_n("killed"), tag.func_74762_e("id"), tag.func_74762_e("cables"), parts);
    }

    @ConstructorProperties(value={"killed", "id", "cables", "parts"})
    public RawNetworkData(boolean killed, int id, int cables, List<RawPartData> parts) {
        this.killed = killed;
        this.id = id;
        this.cables = cables;
        this.parts = parts;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public int getId() {
        return this.id;
    }

    public int getCables() {
        return this.cables;
    }

    public List<RawPartData> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawNetworkData)) {
            return false;
        }
        RawNetworkData other = (RawNetworkData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKilled() != other.isKilled()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getCables() != other.getCables()) {
            return false;
        }
        List<RawPartData> this$parts = this.getParts();
        List<RawPartData> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawNetworkData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKilled() ? 79 : 97);
        result = result * 59 + this.getId();
        result = result * 59 + this.getCables();
        List<RawPartData> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }
}

