/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.network.EnergyNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.PartNetworkConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.core.network.Network;

public class NetworkHelpers {
    public static INetworkCarrier getNetworkCarrier(IBlockAccess world, BlockPos pos) {
        return (INetworkCarrier)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, NetworkCarrierConfig.CAPABILITY);
    }

    public static INetworkElementProvider getNetworkElementProvider(IBlockAccess world, BlockPos pos) {
        return (INetworkElementProvider)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, NetworkElementProviderConfig.CAPABILITY);
    }

    public static INetwork getNetwork(IBlockAccess world, BlockPos pos) {
        INetworkCarrier networkCarrier = NetworkHelpers.getNetworkCarrier(world, pos);
        if (networkCarrier != null) {
            return networkCarrier.getNetwork();
        }
        return null;
    }

    public static IPartNetwork getPartNetwork(@Nullable INetwork network) {
        return network != null && network.hasCapability(PartNetworkConfig.CAPABILITY) ? network.getCapability(PartNetworkConfig.CAPABILITY) : null;
    }

    public static IEnergyNetwork getEnergyNetwork(@Nullable INetwork network) {
        return network != null && network.hasCapability(EnergyNetworkConfig.CAPABILITY) ? network.getCapability(EnergyNetworkConfig.CAPABILITY) : null;
    }

    @Nullable
    public static INetwork initNetwork(World world, BlockPos pos) {
        IPathElement pathElement = (IPathElement)TileHelpers.getCapability((World)world, (BlockPos)pos, null, PathElementConfig.CAPABILITY);
        if (pathElement != null) {
            Network network = Network.initiateNetworkSetup(pathElement);
            network.initialize();
            return network;
        }
        return null;
    }

    public static void onElementProviderBlockNeighborChange(World world, BlockPos pos, Block neighborBlock) {
        if (!world.field_72995_K) {
            INetwork network = NetworkHelpers.getNetwork((IBlockAccess)world, pos);
            INetworkElementProvider networkElementProvider = NetworkHelpers.getNetworkElementProvider((IBlockAccess)world, pos);
            for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                networkElement.onNeighborBlockChange(network, (IBlockAccess)world, neighborBlock);
            }
        }
    }
}

