/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics;

import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;
import org.cyclops.integrateddynamics.IntegratedDynamics;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for Integrated Dynamics.\nDO NOT EDIT MANUALLY!", showInGui=false)
    public static String version = "0.7.12";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The default update frequency in ticks to use for new parts.", minimalValue=1)
    public static int defaultPartUpdateFreq = 1;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The energy usage multiplier for networks.", minimalValue=0)
    public static int energyConsumptionMultiplier = 0;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The maximum render distance for part overlays to render. The higher, the more resource intensive.", isCommandable=true, minimalValue=1)
    public static int partOverlayRenderdistance = 15;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="The chance at which a Menril Tree will spawn in the wild, the higher this value, the lower the chance.", minimalValue=0)
    public static int wildMenrilTreeChance = 350;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If cable models should be cached for rendering optimization.", isCommandable=true)
    public static boolean cacheCableModels = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The maximum network energy transfer rate.", isCommandable=true, minimalValue=0)
    public static int energyRateLimit = Integer.MAX_VALUE;

    public GeneralConfig() {
        super((ModBase)IntegratedDynamics._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        if (!version.equals("0.7.12")) {
            System.err.println("The config file of Integrated Dynamics is out of date and might cause problems, please remove it so it can be regenerated.");
        }
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-4");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)IntegratedDynamics._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.10/IntegratedDynamics.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

