/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class AccelerationWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_20 = 0;
    public static final int MODE_50 = 1;
    public static final int MODE_100 = 2;
    public static final int MODE_LAST = 2;
    private float fakePlayerFactor = 1.0f;
    private boolean lessEffectiveForFakePlayer = false;
    public static final String[] descriptions = new String[]{"fast", "faster", "fastest"};
    public static final int[] amount = new int[]{20, 50, 100};
    public static final float[] cost = new float[]{1.0f, 2.0f, 5.0f};
    private Random random = new Random();

    public AccelerationWand() {
        this.setup("acceleration_wand").xpUsage(5).availability(AVAILABILITY_ADVANCED).loot(2);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(TextFormatting.GREEN + "Mode: " + descriptions[this.getMode(stack)]);
        list.add("Right click on block to speed up ticks.");
        this.showModeKeyDescription(list, "change speed");
        if ((double)Math.abs(this.fakePlayerFactor - 1.0f) >= 0.01) {
            if (this.fakePlayerFactor < 0.0f) {
                list.add(TextFormatting.RED + "Usage in a machine has been disabled in config!");
            } else if (this.fakePlayerFactor > 1.0f) {
                list.add(TextFormatting.YELLOW + "Usage in a machine will cost more!");
            }
        }
        if ((double)this.fakePlayerFactor >= 0.0 && this.lessEffectiveForFakePlayer) {
            list.add(TextFormatting.YELLOW + "Usage in a machine will be less effective!");
        }
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 500, 100000, 200, 200000, 100, 500000);
        this.fakePlayerFactor = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_fakePlayerFactor", (double)this.fakePlayerFactor, "Factor to apply to the cost when this wand is used by a fake player (a machine). Set to -1 to disable its use this way").getDouble();
        this.lessEffectiveForFakePlayer = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_lessEffectiveForFakePlayer", this.lessEffectiveForFakePlayer, "If true this wand will be less effective for fake players").getBoolean();
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            int mode = this.getMode(stack);
            float cost = AccelerationWand.cost[mode];
            int amount = AccelerationWand.amount[mode];
            if (player instanceof FakePlayer) {
                if (this.fakePlayerFactor < 0.0f) {
                    return EnumActionResult.FAIL;
                }
                cost *= this.fakePlayerFactor;
                if (this.lessEffectiveForFakePlayer) {
                    amount /= 2;
                }
            }
            if (!this.checkUsage(stack, player, cost)) {
                return EnumActionResult.FAIL;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            for (int i = 0; i < amount / (tileEntity == null ? 5 : 1); ++i) {
                if (tileEntity == null) {
                    block.func_180650_b(world, pos, state, this.random);
                    continue;
                }
                if (!(tileEntity instanceof ITickable)) continue;
                ((ITickable)tileEntity).func_73660_a();
            }
            this.registerUsage(stack, player, cost);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }

    @Override
    protected void setupCraftingInt(Item wandcore) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"gg ", "gw ", "  w", Character.valueOf('g'), new ItemStack(Items.field_151100_aR, 1, 15), Character.valueOf('w'), wandcore});
    }
}

