/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryStorageModifiable
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    protected ItemStack[] stacks;
    public TileEntity inventoryTile;
    private String ID = "Items";

    public InventoryStorageModifiable(TileEntity tile, int invtSize) {
        this.inventoryTile = tile;
        this.stacks = new ItemStack[invtSize];
    }

    public void setSize(int size) {
        this.stacks = new ItemStack[size];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)this.stacks[slot], (ItemStack)stack)) {
            return;
        }
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.canInteractWithSlot(slot)) {
            return null;
        }
        this.validateSlotIndex(slot);
        return this.stacks[slot];
    }

    public ItemStack getStackInSlotInternal(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks[slot];
    }

    public boolean canInteractWithSlot(int slot) {
        return true;
    }

    public boolean isItemValidForslot(int Slot2, ItemStack stack) {
        return true;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        if (!this.isItemValidForslot(slot, stack)) {
            return null;
        }
        ItemStack existing = this.stacks[slot];
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (existing == null) {
                this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    public ItemStack extractItemIternal(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractStack(slot, amount, simulate);
    }

    private ItemStack extractStack(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.stacks[slot];
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.stacks[slot] = null;
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tags = nbt.func_74775_l(this.ID);
        this.deserializeNBT(tags);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tags = this.serializeNBT();
        nbt.func_74782_a(this.ID, (NBTBase)tags);
        return nbt;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            this.stacks[i].func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.length);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.length);
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTags);
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.length) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.length + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

