/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class InventoryStorage
implements IInventory {
    public ItemStack[] inventory;
    public TileEntity inventoryTile;
    private String ID = "Items";

    public InventoryStorage(TileEntity tile, int invtSize) {
        this.inventory = new ItemStack[invtSize];
        this.inventoryTile = tile;
    }

    public InventoryStorage setID(String id) {
        this.ID = id;
        return this;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.length ? this.inventory[index] : null;
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)slot, (int)count);
        if (itemstack != null) {
            this.inventoryTile.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList tags = nbt.func_150295_c(this.ID, 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data = tags.func_150305_b(i);
            int j = data.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a(this.ID, (NBTBase)tags);
        return nbt;
    }

    @Nullable
    public ItemStack addItem(ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            int j;
            int k;
            ItemStack itemstack1 = this.func_70301_a(i);
            if (itemstack1 == null) {
                this.func_70299_a(i, itemstack);
                this.func_70296_d();
                return null;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack) || (k = Math.min(itemstack.field_77994_a, (j = Math.min(this.func_70297_j_(), itemstack1.func_77976_d())) - itemstack1.field_77994_a)) <= 0) continue;
            itemstack1.field_77994_a += k;
            itemstack.field_77994_a -= k;
            if (itemstack.field_77994_a > 0) continue;
            this.func_70296_d();
            return null;
        }
        if (itemstack.field_77994_a != stack.field_77994_a) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_174889_b(EntityPlayer playerIn) {
    }

    public void func_174886_c(EntityPlayer playerIn) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70296_d() {
        this.inventoryTile.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }
}

