/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.waila;

import com.gendeathrow.hatchery.block.feeder.FeederTileEntity;
import com.gendeathrow.hatchery.block.nest.EggNestTileEntity;
import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HatcheryTileProvider
implements IWailaDataProvider,
IWailaPlugin {
    private static final HatcheryTileProvider INSTANCE = new HatcheryTileProvider();

    public void register(IWailaRegistrar registrar) {
        HatcheryTileProvider.load(registrar);
    }

    public static void load(IWailaRegistrar registrar) {
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, EggNestTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, EggNestTileEntity.class);
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, NestPenTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, NestPenTileEntity.class);
        registrar.registerTailProvider((IWailaDataProvider)INSTANCE, FeederTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, FeederTileEntity.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof EggNestTileEntity) {
            EggNestTileEntity hte = (EggNestTileEntity)tileEntity;
            if (accessor.getNBTData().func_74767_n("hasEgg")) {
                float percentage = accessor.getNBTData().func_74760_g("hatchPercentage");
                currenttip.add(I18n.func_135052_a((String)"text.hatchery.hatching", (Object[])new Object[0]) + ": " + percentage + "%");
                currenttip.add(accessor.getNBTData().func_74779_i("eggName"));
            } else {
                currenttip.add(I18n.func_135052_a((String)"text.hatchery.nothatching", (Object[])new Object[0]));
            }
        } else if (tileEntity instanceof NestPenTileEntity) {
            NBTTagList inv;
            if (accessor.getNBTData().func_74767_n("hasChicken")) {
                currenttip.add(I18n.func_135052_a((String)"text.hatchery.chicken", (Object[])new Object[0]) + ": " + accessor.getNBTData().func_74779_i("entityname"));
                if (accessor.getNBTData().func_74764_b("Growth")) {
                    currenttip.add("Growth: " + accessor.getNBTData().func_74762_e("Growth"));
                }
                if (accessor.getNBTData().func_74764_b("Gain")) {
                    currenttip.add("Gain: " + accessor.getNBTData().func_74762_e("Gain"));
                }
                if (accessor.getNBTData().func_74764_b("Strength")) {
                    currenttip.add("Strength: " + accessor.getNBTData().func_74762_e("Strength"));
                }
                long uptime = accessor.getNBTData().func_74763_f("nextDrop") / 20L;
                long minutes = TimeUnit.SECONDS.toMinutes(uptime);
                long seconds = TimeUnit.SECONDS.toSeconds(uptime -= TimeUnit.MINUTES.toSeconds(minutes));
                String output = minutes > 0L ? minutes + ":" + (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + " mins" : (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + " secs";
                currenttip.add(I18n.func_135052_a((String)"text.hatchery.nxdrop", (Object[])new Object[0]) + ": " + output);
            } else {
                currenttip.add(I18n.func_135052_a((String)"text.hatchery.nochicken", (Object[])new Object[0]));
            }
            if (accessor.getNBTData().func_74764_b("inventory") && (inv = (NBTTagList)accessor.getNBTData().func_74781_a("inventory")) != null) {
                for (int i = 0; i < inv.func_74745_c(); ++i) {
                    NBTTagCompound item = inv.func_150305_b(i);
                    currenttip.add("Slot " + item.func_74771_c("Slot") + ": " + item.func_74779_i("id") + " x" + item.func_74762_e("cnt"));
                }
            }
        } else if (tileEntity instanceof FeederTileEntity && accessor.getNBTData().func_74764_b("qty")) {
            accessor.getNBTData().func_74779_i("qty");
            currenttip.add(I18n.func_135052_a((String)"text.hatchery.storedseed", (Object[])new Object[0]) + ": " + accessor.getNBTData().func_74779_i("qty"));
        }
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof EggNestTileEntity) {
            EggNestTileEntity hte = (EggNestTileEntity)te;
            float hatchPercentage = 0.0f;
            String eggName = "";
            float hasEgg = 0.0f;
            if (hte.getStackInSlot(0) != null) {
                tag.func_74776_a("hatchPercentage", hte.getPercentage());
                tag.func_74778_a("eggName", hte.getStackInSlot(0).func_82833_r());
            }
            tag.func_74757_a("hasEgg", hte.getStackInSlot(0) != null);
        } else if (te instanceof NestPenTileEntity) {
            NestPenTileEntity hte = (NestPenTileEntity)te;
            tag.func_74757_a("hasChicken", hte.storedEntity() != null);
            if (hte.storedEntity() != null) {
                tag.func_74778_a("entityname", hte.storedEntity().func_145748_c_().func_150254_d());
                NBTTagCompound entityNBT = hte.storedEntity().getEntityData();
                if (entityNBT.func_74764_b("Gain")) {
                    tag.func_74768_a("Gain", entityNBT.func_74762_e("Gain"));
                }
                if (entityNBT.func_74764_b("Strength")) {
                    tag.func_74768_a("Strength", entityNBT.func_74762_e("Strength"));
                }
                if (entityNBT.func_74764_b("Growth")) {
                    tag.func_74768_a("Growth", entityNBT.func_74762_e("Growth"));
                }
            }
            tag.func_74772_a("nextDrop", (long)hte.getTimeToNextDrop());
            NBTTagList list = NestPenTileEntity.getInventoryContents(hte);
            if (list != null) {
                tag.func_74782_a("inventory", (NBTBase)list);
            }
        } else if (te instanceof FeederTileEntity) {
            FeederTileEntity hte = (FeederTileEntity)te;
            tag.func_74778_a("qty", hte.getSeedsInv() + "/" + hte.getMaxSeedInv());
        }
        return tag;
    }
}

