/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.shredder;

import cofh.api.energy.IEnergyReceiver;
import com.gendeathrow.hatchery.api.tileentities.IContainerUpdate;
import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.block.shredder.ShredderBlock;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class ShredderTileEntity
extends TileUpgradable
implements ITickable,
IContainerUpdate,
IEnergyReceiver {
    public EnergyStorageRF energy = new EnergyStorageRF(100000).setMaxReceive(100);
    public int animationTicks;
    public int prevAnimationTicks;
    protected InventoryStroageModifiable inventory = new InventoryStroageModifiable(3){

        @Override
        public boolean canExtractSlot(int slot) {
            return slot > 0;
        }

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return slot == 0 && ShredderTileEntity.isShreddableItem(stack);
        }
    };
    public static ArrayList<ShredderRecipe> shredderRecipes = new ArrayList();
    private int transferCooldown = -1;
    int slotIn = 0;
    private int shreddingTime;
    private int currentItemShreddingTime;
    private int shredTime;
    private int totalshredTime;
    private int rfTick = 20;
    private ItemStack shreddedItem;

    public ShredderTileEntity() {
        super(2);
        shredderRecipes.add(new ShredderRecipe(new ItemStack(Items.field_151008_G), new ItemStack(ModItems.featherFiber), new ItemStack(ModItems.featherMeal)));
        shredderRecipes.add(new ShredderRecipe(new ItemStack(ModItems.featherFiber), new ItemStack(ModItems.featherMeal)));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && ShredderBlock.isActive(this.field_145850_b.func_180495_p(this.field_174879_c))) {
            this.prevAnimationTicks = this.animationTicks;
            if (this.animationTicks < 360) {
                this.animationTicks += 5;
            }
            if (this.animationTicks >= 360) {
                this.animationTicks -= 360;
                this.prevAnimationTicks -= 360;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean flag = this.isShredding();
            boolean flag1 = false;
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.captureDroppedItems();
                this.setTransferCooldown(8);
            }
            if (!this.isShredding() && this.canShred() && this.hasPower()) {
                this.currentItemShreddingTime = this.shreddingTime = this.setShredTime(this.inventory.getStackInSlot(0));
                if (this.isShredding()) {
                    this.shreddedItem = this.inventory.extractItemInternal(0, 1, false);
                }
            }
            if (this.isShredding() && this.hasPower()) {
                --this.shreddingTime;
                this.energy.extractEnergy(20, false);
                if (this.shreddingTime <= 0) {
                    this.shredItem();
                }
            }
            if (flag != (this.isShredding() && this.hasPower())) {
                flag1 = true;
                ShredderBlock.setActive(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.isShredding() && this.hasPower());
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    public int getShreddingTime() {
        return this.shreddingTime;
    }

    public int getTotalShredTime() {
        return this.shredTime;
    }

    public int setShredTime(ItemStack stack) {
        this.shredTime = this.getRecipe(stack).shredTime;
        return this.shredTime;
    }

    public void shredItem() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        boolean flag = false;
        if (this.shreddedItem != null) {
            ShredderRecipe recipe;
            if (ShredderTileEntity.isShreddableItem(this.shreddedItem) && (recipe = this.getRecipe(this.shreddedItem)) != null && recipe.hasOutput()) {
                ItemStack extra;
                this.inventory.insertItemInternal(1, recipe.getOutputItem(), false);
                if (recipe.hasExtraOutput() && (extra = recipe.getExtraItem()) != null) {
                    this.inventory.insertItemInternal(2, extra, false);
                }
                flag = true;
            }
        }
    }

    private boolean canShred() {
        if (this.inventory.getStackInSlot(0) == null) {
            return false;
        }
        ShredderRecipe recipe = this.getRecipe(this.inventory.getStackInSlot(0));
        if (recipe == null) {
            return false;
        }
        ItemStack itemstack = recipe.itemOut;
        if (itemstack == null) {
            return false;
        }
        if (this.inventory.getStackInSlot(1) == null) {
            return true;
        }
        if (!this.inventory.getStackInSlot(1).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory.getStackInSlot((int)1).field_77994_a + itemstack.field_77994_a;
        return result <= 64 && result <= this.inventory.getStackInSlot(1).func_77976_d();
    }

    public boolean isShredding() {
        return this.shreddingTime > 0;
    }

    public boolean hasPower() {
        return this.energy.getEnergyStored() >= this.rfTick;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShredding(IInventory inventory) {
        return inventory.func_174887_a_(1) > 0;
    }

    protected ShredderRecipe getRecipe(ItemStack stack) {
        for (ShredderRecipe recipe : shredderRecipes) {
            if (!recipe.isInputItem(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isShreddableItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ShredderRecipe recipe : shredderRecipes) {
            if (!recipe.isInputItem(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void setTransferCooldown(int cooldown) {
        this.transferCooldown = cooldown;
    }

    public boolean captureDroppedItems() {
        EnumFacing enumfacing = EnumFacing.DOWN;
        boolean flag = false;
        for (EntityItem entityitem : ShredderTileEntity.getCaptureItems(this.field_145850_b, this.getXPos(), this.getYPos(), this.getZPos())) {
            if (!ShredderTileEntity.isShreddableItem(entityitem.func_92059_d())) continue;
            ItemStack itemstack = entityitem.func_92059_d().func_77946_l();
            ItemStack itemstack1 = this.inventory.insertItemInternal(0, itemstack, false);
            if (itemstack1 != null && itemstack1.field_77994_a != 0) {
                entityitem.func_92058_a(itemstack1);
            } else {
                flag = true;
                entityitem.func_70106_y();
            }
            return flag;
        }
        return flag;
    }

    public static List<EntityItem> getCaptureItems(World worldIn, double x, double y, double z) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(x - 0.5, y, z - 0.5, x + 0.5, y + 1.5, z + 0.5), EntitySelectors.field_94557_a);
    }

    public double getXPos() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double getYPos() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double getZPos() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.energy.getEnergyStored();
            }
            case 1: {
                return this.shreddingTime;
            }
            case 2: {
                return this.currentItemShreddingTime;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 1: {
                this.shreddingTime = value;
                break;
            }
            case 2: {
                this.currentItemShreddingTime = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        this.energy.writeToNBT(tag);
        return tag;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == ModBlocks.shredder && newSate.func_177230_c() == ModBlocks.shredder) {
            return false;
        }
        return oldState != newSate;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public class ShredderRecipe {
        private ItemStack itemIn;
        private ItemStack itemOut;
        private ItemStack itemExtra;
        private int chance;
        private int shredTime;
        private Random rand = new Random();

        public ShredderRecipe(ItemStack itemIn, ItemStack itemOut) {
            this(itemIn, itemOut, null);
        }

        public ShredderRecipe(ItemStack itemIn, ItemStack itemOut, ItemStack itemExtra) {
            this(itemIn, itemOut, itemExtra, 3, 100);
        }

        public ShredderRecipe(ItemStack itemIn, ItemStack itemOut, ItemStack itemExtra, int chance, int shredTime) {
            this.itemIn = itemIn;
            this.itemOut = itemOut;
            this.itemExtra = itemExtra;
            this.chance = chance;
            this.shredTime = shredTime;
        }

        public boolean isInputItem(ItemStack stack) {
            return this.itemIn.func_77969_a(stack);
        }

        public boolean hasOutput() {
            return this.itemOut != null;
        }

        public boolean hasExtraOutput() {
            return this.itemExtra != null;
        }

        public ItemStack getOutputItem() {
            return this.itemOut.func_77946_l();
        }

        @Nullable
        public ItemStack getExtraItem() {
            if (this.rand.nextInt(this.chance) == 1) {
                return this.itemExtra.func_77946_l();
            }
            return null;
        }
    }
}

