/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.fertilizermixer;

import cofh.api.energy.IEnergyReceiver;
import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.inventory.InventoryStorage;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerFluidMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FertilizerMixerTileEntity
extends TileUpgradable
implements IInventory,
ITickable,
IEnergyReceiver {
    private FluidTank waterTank = new FluidTank(new FluidStack(FluidRegistry.WATER, 0), 20000){

        public boolean canDrain() {
            return false;
        }
    };
    private FluidTank fertilizerTank = new FluidTank(new FluidStack(ModFluids.liquidfertilizer, 0), 20000){

        public boolean canFill() {
            return false;
        }
    };
    private FluidHandlerFluidMap fluidMap = new FluidHandlerFluidMap().addHandler(ModFluids.liquidfertilizer, (IFluidHandler)this.fertilizerTank).addHandler(FluidRegistry.WATER, (IFluidHandler)this.waterTank);
    protected InventoryStorage inventory = new InventoryStorage(this, 5);
    protected EnergyStorageRF energy = new EnergyStorageRF(20000).setMaxReceive(100);
    private int fertlizerMixTime;
    private int currentItemMixTime;
    private int mixTime;
    private int totalMixTime;
    public int waterLevel = 0;
    public int fertilizerLevel = 0;
    public int storedEnergyLevel = 0;

    public FertilizerMixerTileEntity() {
        super(2);
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public FluidTank getFertilizerTank() {
        return this.fertilizerTank;
    }

    public ItemStack[] getItemInventory() {
        return this.inventory.getInventory();
    }

    public boolean isMixing() {
        return this.fertlizerMixTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMixing(IInventory inventory) {
        return inventory.func_174887_a_(2) > 0;
    }

    public boolean canMix() {
        return this.waterTank.getFluidAmount() > 0 && this.fertilizerTank.getFluidAmount() < this.fertilizerTank.getCapacity();
    }

    public static int getItemMixTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == ModItems.manure) {
            return 100;
        }
        if (item == Item.func_150898_a((Block)ModBlocks.manureBlock)) {
            return 1120;
        }
        return 0;
    }

    public void func_73660_a() {
        boolean flag = this.isMixing();
        boolean flag1 = false;
        if (this.isMixing()) {
            --this.fertlizerMixTime;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            IFluidHandler handler;
            ItemStack newStack;
            if (this.isMixing() || this.inventory.func_70301_a(0) != null) {
                if (!this.isMixing() && this.canMix()) {
                    this.currentItemMixTime = this.fertlizerMixTime = FertilizerMixerTileEntity.getItemMixTime(this.inventory.func_70301_a(0));
                    if (this.isMixing()) {
                        flag1 = true;
                        if (this.inventory.func_70301_a(0) != null) {
                            --this.inventory.func_70301_a((int)0).field_77994_a;
                            if (this.inventory.func_70301_a((int)0).field_77994_a <= 0) {
                                this.inventory.func_70299_a(0, null);
                            }
                        }
                    }
                }
                if (this.isMixing() && this.canMix() && this.fertlizerMixTime >= 5 && this.energy.getEnergyStored() >= 10) {
                    this.fertlizerMixTime -= 5;
                    this.energy.extractEnergy(10, false);
                    this.fertilizerTank.fillInternal(new FluidStack(ModFluids.liquidfertilizer, 5), true);
                    this.waterTank.drainInternal(5, true);
                    flag1 = true;
                } else if (this.isMixing() && this.canMix() && this.fertlizerMixTime >= 1) {
                    --this.fertlizerMixTime;
                    this.fertilizerTank.fillInternal(new FluidStack(ModFluids.liquidfertilizer, 1), true);
                    this.waterTank.drainInternal(1, true);
                    flag1 = true;
                } else {
                    this.mixTime = 0;
                }
            } else if (!this.isMixing() && this.mixTime > 0) {
                this.mixTime = MathHelper.func_76125_a((int)(this.mixTime - 2), (int)0, (int)this.totalMixTime);
            }
            if (this.func_70301_a(1) != null && this.waterTank.getFluidAmount() < this.waterTank.getCapacity()) {
                ItemStack stack = this.func_70301_a(1);
                newStack = this.func_70301_a(1).func_77946_l();
                newStack.field_77994_a = 1;
                handler = FluidUtil.getFluidHandler((ItemStack)newStack);
                if (handler != null && this.func_70301_a(2) == null && FluidUtil.tryFluidTransfer((IFluidHandler)this.waterTank, (IFluidHandler)handler, (int)this.waterTank.getCapacity(), (boolean)true) != null) {
                    if (newStack.field_77994_a > 0) {
                        this.inventory.func_70299_a(2, newStack);
                    }
                    this.func_70298_a(1, 1);
                }
            }
            if (this.inventory.func_70301_a(3) != null && this.inventory.func_70301_a(4) == null && this.fertilizerTank.getFluidAmount() > 0) {
                ItemStack oldStack = this.inventory.func_70301_a(3);
                newStack = this.inventory.func_70301_a(3).func_77946_l();
                if (newStack.field_77994_a > 1) {
                    newStack.field_77994_a = 1;
                }
                if ((handler = FluidUtil.getFluidHandler((ItemStack)newStack)) != null && FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.fertilizerTank, (int)this.fertilizerTank.getCapacity(), (boolean)true) != null) {
                    this.func_70299_a(4, newStack);
                    if (oldStack.field_77994_a > 1) {
                        this.func_70298_a(3, 1);
                    } else {
                        this.func_70299_a(3, null);
                    }
                }
            }
        }
        if (flag != this.isMixing()) {
            flag1 = true;
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getMixTime(@Nullable ItemStack stack) {
        return 200;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inventory.func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0 && (stack.func_77973_b() == ModItems.manure || stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.manureBlock))) {
            return true;
        }
        if (index == 1 && stack.func_77973_b() == Items.field_151131_as) {
            return true;
        }
        return index == 3 && stack.func_77973_b() == ModFluids.getFertilizerBucket().func_77973_b();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.waterTank.getFluidAmount();
            }
            case 1: {
                return this.fertilizerTank.getFluidAmount();
            }
            case 2: {
                return this.fertlizerMixTime;
            }
            case 3: {
                return this.energy.getEnergyStored();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.waterLevel = value;
                break;
            }
            case 1: {
                this.fertilizerLevel = value;
                break;
            }
            case 2: {
                this.fertlizerMixTime = value;
            }
            case 3: {
                this.energy.setEnergyStored(value);
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.waterTank.readFromNBT(tag.func_74775_l("waterTank"));
        this.fertilizerTank.readFromNBT(tag.func_74775_l("fertilizerTank"));
        this.energy.readFromNBT(tag);
        this.inventory.readFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound waterTTag = new NBTTagCompound();
        NBTTagCompound fertTTag = new NBTTagCompound();
        this.waterTank.writeToNBT(waterTTag);
        this.fertilizerTank.writeToNBT(fertTTag);
        tag.func_74782_a("waterTank", (NBTBase)waterTTag);
        tag.func_74782_a("fertilizerTank", (NBTBase)fertTTag);
        this.inventory.writeToNBT(tag);
        this.energy.writeToNBT(tag);
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidMap;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }
}

