/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.fertilizedDirt;

import com.gendeathrow.hatchery.core.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FertilizedFarmland
extends Block {
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public FertilizedFarmland() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(1.0f);
        this.setHarvestLevel("shovel", 0);
        this.func_149663_c("fertilized_farmland");
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149713_g(255);
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FARMLAND_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176214_u() {
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IGrowable igrowable;
        IBlockState iblockstate;
        int i = (Integer)state.func_177229_b((IProperty)MOISTURE);
        if (!this.hasWater(worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops(worldIn, pos)) {
                worldIn.func_175656_a(pos, ModBlocks.fertlizedDirt.func_176223_P());
            }
        } else if (i < 7) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        if (this.hasCrops(worldIn, pos) && this.hasWater(worldIn, pos) && rand.nextInt(2) == 0 && (iblockstate = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)iblockstate.func_177230_c()).func_176473_a(worldIn, pos.func_177984_a(), iblockstate, worldIn.field_72995_K)) {
            Block o = Blocks.field_150458_ak;
            if (!worldIn.field_72995_K) {
                if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos.func_177984_a(), iblockstate)) {
                    igrowable.func_176474_b(worldIn, worldIn.field_73012_v, pos.func_177984_a(), iblockstate);
                    worldIn.func_175718_b(2005, pos.func_177984_a(), 0);
                } else {
                    worldIn.func_180497_b(pos.func_177984_a(), iblockstate.func_177230_c(), 20, 1);
                    iblockstate.func_177230_c().func_180650_b(worldIn, pos.func_177984_a(), iblockstate, rand);
                    worldIn.func_175718_b(2005, pos.func_177984_a(), 0);
                }
            }
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextFloat() < fallDistance - 0.5f && entityIn instanceof EntityLivingBase && (entityIn instanceof EntityPlayer || worldIn.func_82736_K().func_82766_b("mobGriefing")) && entityIn.field_70130_N * entityIn.field_70130_N * entityIn.field_70131_O > 0.512f) {
            worldIn.func_175656_a(pos, ModBlocks.fertlizedDirt.func_176223_P());
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private boolean hasCrops(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }

    private boolean hasWater(World worldIn, BlockPos pos) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, ModBlocks.fertlizedDirt.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != ModBlocks.fertilzedFarmland;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModBlocks.fertlizedDirt.func_180660_a(ModBlocks.fertlizedDirt.func_176223_P(), rand, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModBlocks.fertlizedDirt);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        return plant.func_177230_c() instanceof BlockBush;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return true;
    }
}

