/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.eggmachine;

import cofh.api.energy.IEnergyReceiver;
import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.block.eggmachine.EggMachineBlock;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.inventory.InventoryStorage;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EggMachineTileEntity
extends TileUpgradable
implements ITickable,
IInventory,
IEnergyReceiver {
    public int EggInSlot = 0;
    public int PlasticInSlot = 1;
    public int PrizeEggSlot = 2;
    protected InventoryStorage inventory = new InventoryStorage(this, 3){

        @Override
        public boolean func_94041_b(int index, ItemStack stack) {
            if (index == EggMachineTileEntity.this.EggInSlot && stack.func_77973_b() instanceof ItemEgg) {
                return true;
            }
            return index == EggMachineTileEntity.this.PlasticInSlot && stack.func_77973_b() == ModItems.plastic;
        }
    };
    protected EnergyStorageRF energy = new EnergyStorageRF(20000){

        @Override
        public boolean canExtract() {
            return false;
        }
    }.setMaxReceive(100);
    protected int internalEggStorage = 0;
    protected int internalPlasticStorage = 0;
    private int eggToPrizeSize = 24;
    private int eggTime = 0;
    float zeroedFacing;
    float currentFacing;
    float prevAnimationTicks;
    float animationTicks;
    boolean firstRun = true;

    public EggMachineTileEntity() {
        super(2);
    }

    public void updateClient() {
        if (this.firstRun) {
            this.firstRun = false;
            EnumFacing facing = EggMachineBlock.getFacing(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.animationTicks = this.zeroedFacing = facing.func_185119_l();
        }
        this.prevAnimationTicks = this.animationTicks;
        if (this.animationTicks < 360.0f) {
            this.animationTicks += 5.0f;
        }
        if (this.animationTicks >= 360.0f) {
            this.animationTicks -= 360.0f;
            this.prevAnimationTicks -= 360.0f;
        }
    }

    public void func_73660_a() {
        boolean hasRoomForEgg;
        if (this.field_145850_b.field_72995_K) {
            this.updateClient();
        }
        ItemStack eggIn = this.inventory.func_70301_a(this.EggInSlot);
        ItemStack plasticIn = this.inventory.func_70301_a(this.PlasticInSlot);
        if (eggIn != null && eggIn.func_77973_b() instanceof ItemEgg) {
            this.internalEggStorage += eggIn.field_77994_a;
            this.inventory.func_70299_a(this.EggInSlot, null);
        }
        if (plasticIn != null && plasticIn.func_77973_b() == ModItems.plastic) {
            this.internalPlasticStorage += plasticIn.field_77994_a;
            this.inventory.func_70299_a(this.PlasticInSlot, null);
        }
        if (this.eggTime <= 0 && this.canMakePrizeEgg()) {
            this.eggTime = 200;
            this.internalEggStorage -= this.eggToPrizeSize;
            this.internalPlasticStorage -= 2;
            this.func_70296_d();
        }
        boolean hasTimeLeft = this.eggTime > 0;
        ItemStack prizeSlot = this.inventory.func_70301_a(this.PrizeEggSlot);
        boolean bl = prizeSlot == null ? true : (hasRoomForEgg = prizeSlot.field_77994_a < prizeSlot.func_77976_d());
        if (!this.field_145850_b.field_72995_K && hasTimeLeft && this.energy.getEnergyStored() >= 40 && hasRoomForEgg) {
            --this.eggTime;
            this.energy.extractEnergy(40, false);
            if (this.eggTime <= 0) {
                this.createPrizeEgg();
                this.func_70296_d();
            }
        }
    }

    private boolean canMakePrizeEgg() {
        return this.eggToPrizeSize <= this.internalEggStorage && this.internalPlasticStorage >= 2;
    }

    private void createPrizeEgg() {
        ItemStack itemstack = new ItemStack(ModItems.prizeEgg);
        ItemStack eggStack = this.inventory.func_70301_a(this.PrizeEggSlot);
        if (eggStack == null) {
            this.inventory.func_70299_a(this.PrizeEggSlot, itemstack);
        } else if (eggStack.func_77973_b() == ModItems.prizeEgg && eggStack.field_77994_a < eggStack.func_77976_d()) {
            ++eggStack.field_77994_a;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.readFromNBT(compound);
        this.energy.readFromNBT(compound);
        this.internalEggStorage = compound.func_74762_e("EggStorage");
        this.internalPlasticStorage = compound.func_74762_e("PlasticStorage");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.inventory.writeToNBT(compound);
        this.energy.writeToNBT(compound);
        compound.func_74768_a("EggStorage", this.internalEggStorage);
        compound.func_74768_a("PlasticStorage", this.internalPlasticStorage);
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.energy.getEnergyStored();
            }
            case 1: {
                return this.internalEggStorage;
            }
            case 2: {
                return this.internalPlasticStorage;
            }
            case 3: {
                return this.eggTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 1: {
                this.internalEggStorage = value;
                break;
            }
            case 2: {
                this.internalPlasticStorage = value;
                break;
            }
            case 3: {
                this.eggTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }
}

