/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.util.List;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.security.OrphaningCardItem;
import mcjty.rftools.blocks.security.PacketGetSecurityName;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SecurityCardItem
extends GenericRFToolsItem {
    public static String channelNameFromServer = "";
    private static long lastTime = 0L;

    public SecurityCardItem() {
        super("security_card");
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        int channel = -1;
        if (tagCompound != null && tagCompound.func_74764_b("channel")) {
            channel = tagCompound.func_74762_e("channel");
        }
        if (channel != -1) {
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetSecurityName(channel));
            }
            list.add(TextFormatting.YELLOW + "Channel: " + channel + " (" + channelNameFromServer + ")");
        } else {
            list.add(TextFormatting.YELLOW + "Channel is not set!");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Manage security channels in the Security Manager");
            list.add(TextFormatting.WHITE + "and link this card to a channel. Sneak right-click");
            list.add(TextFormatting.WHITE + "a block to link the channel to that block.");
            list.add(TextFormatting.WHITE + "If you want to copy the channel from a block to");
            list.add(TextFormatting.WHITE + "a card you can right click with an unlinked card");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof GenericTileEntity) {
                GenericTileEntity genericTileEntity = (GenericTileEntity)te;
                if (genericTileEntity.getOwnerUUID() == null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "This block has no owner!"));
                } else if (OrphaningCardItem.isPrivileged(player, world) || this.isOwner(player, genericTileEntity)) {
                    NBTTagCompound tagCompound = stack.func_77978_p();
                    if (tagCompound == null || !tagCompound.func_74764_b("channel")) {
                        int blockSecurity = genericTileEntity.getSecurityChannel();
                        if (blockSecurity == -1) {
                            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "This security card is not setup correctly!"));
                        } else {
                            if (tagCompound == null) {
                                tagCompound = new NBTTagCompound();
                                stack.func_77982_d(tagCompound);
                            }
                            tagCompound.func_74768_a("channel", blockSecurity);
                            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Copied security channel from block to card!"));
                        }
                    } else {
                        int channel = tagCompound.func_74762_e("channel");
                        this.toggleSecuritySettings(player, genericTileEntity, channel);
                    }
                } else {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You cannot change security settings of a block you don't own!"));
                }
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Security is not supported on this block!"));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean isOwner(EntityPlayer player, GenericTileEntity genericTileEntity) {
        return genericTileEntity.getOwnerUUID().equals(player.getPersistentID());
    }

    private void toggleSecuritySettings(EntityPlayer player, GenericTileEntity genericTileEntity, int channel) {
        int sec = genericTileEntity.getSecurityChannel();
        if (sec == channel) {
            genericTileEntity.setSecurityChannel(-1);
            Logging.message((EntityPlayer)player, (String)"Security settings cleared from block!");
        } else {
            genericTileEntity.setSecurityChannel(channel);
            Logging.message((EntityPlayer)player, (String)"Security settings applied on block!");
        }
    }
}

