/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.threelogic;

import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class ThreeLogicTileEntity
extends LogicTileEntity
implements ITickable {
    public static final String CMD_SETSTATE = "setState";
    private int[] logicTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0};

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    public int getState(int index) {
        return this.logicTable[index];
    }

    private void checkStateServer() {
        int s = this.logicTable[this.powerLevel];
        if (s == -1) {
            return;
        }
        this.setRedstoneState(s == 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74767_n("rs");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        for (int i = 0; i < 8; ++i) {
            this.logicTable[i] = tagCompound.func_74762_e("state" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powered);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        for (int i = 0; i < 8; ++i) {
            tagCompound.func_74768_a("state" + i, this.logicTable[i]);
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETSTATE.equals(command)) {
            this.logicTable[args.get((Object)"index").getInteger().intValue()] = args.get("state").getInteger();
            this.func_70296_d();
            this.markDirtyClient();
            return true;
        }
        return false;
    }
}

