/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.List;
import mcjty.lib.varia.EnergyTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInfo {
    private BlockPos coordinate;
    private int energyStored;
    private int maxEnergyStored;

    public BlockInfo(TileEntity tileEntity, BlockPos coordinate) {
        this.coordinate = coordinate;
        this.fetchEnergyValues(tileEntity);
    }

    public BlockInfo(BlockPos coordinate, int energyStored, int maxEnergyStored) {
        this.coordinate = coordinate;
        this.energyStored = energyStored;
        this.maxEnergyStored = maxEnergyStored;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public static String getReadableName(IBlockState state) {
        return BlockInfo.getReadableName(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static String getReadableName(Block block, BlockPos coordinate, int metadata, World world) {
        List itemStacks = block.getDrops((IBlockAccess)world, coordinate, world.func_180495_p(coordinate), 1);
        if (itemStacks != null && !itemStacks.isEmpty() && ((ItemStack)itemStacks.get(0)).func_77973_b() != null) {
            return BlockInfo.getReadableName(((ItemStack)itemStacks.get(0)).func_77973_b(), metadata);
        }
        return BlockInfo.getReadableName(block, metadata);
    }

    public static String getReadableName(Object object, int metadata) {
        if (object instanceof Block) {
            return BlockInfo.getReadableName((Block)object, metadata);
        }
        if (object instanceof Item) {
            return BlockInfo.getReadableName((Item)object, metadata);
        }
        if (object instanceof ItemStack) {
            ItemStack s = (ItemStack)object;
            return s.func_82833_r();
        }
        return "?";
    }

    public static String getReadableName(Block block, int metadata) {
        ItemStack s = new ItemStack(block, 1, metadata);
        if (s.func_77973_b() == null) {
            return block.func_149739_a();
        }
        String displayName = s.func_82833_r();
        if (displayName.startsWith("tile.")) {
            displayName = displayName.substring(5);
        }
        if (displayName.endsWith(".name")) {
            displayName = displayName.substring(0, displayName.length() - 5);
        }
        return displayName;
    }

    private static String getReadableName(Item item, int metadata) {
        ItemStack s = new ItemStack(item, 1, metadata);
        String displayName = s.func_82833_r();
        if (displayName.startsWith("tile.")) {
            displayName = displayName.substring(5);
        }
        if (displayName.endsWith(".name")) {
            displayName = displayName.substring(0, displayName.length() - 5);
        }
        return displayName;
    }

    private void fetchEnergyValues(TileEntity tileEntity) {
        EnergyTools.EnergyLevel energyLevel = EnergyTools.getEnergyLevel((TileEntity)tileEntity);
        this.maxEnergyStored = energyLevel.getMaxEnergy();
        this.energyStored = energyLevel.getEnergy();
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)o;
        if (this.energyStored != blockInfo.energyStored) {
            return false;
        }
        if (this.maxEnergyStored != blockInfo.maxEnergyStored) {
            return false;
        }
        return !(this.coordinate != null ? !this.coordinate.equals((Object)blockInfo.coordinate) : blockInfo.coordinate != null);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + this.energyStored;
        result = 31 * result + this.maxEnergyStored;
        return result;
    }
}

