/*
 * Decompiled with CFR 0.152.
 */
package panda.corn.entity;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import panda.corn.entity.EntityParticlePopcornFX;

public class MyEntityFireworkRocket
extends Entity {
    private static final DataParameter<Optional<ItemStack>> FIREWORK_ITEM = EntityDataManager.func_187226_a(MyEntityFireworkRocket.class, (DataSerializer)DataSerializers.field_187196_f);
    public int fireworkAge;
    private int lifetime;

    public MyEntityFireworkRocket(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public MyEntityFireworkRocket(World worldIn, double x, double y, double z, @Nullable ItemStack givenItem) {
        super(worldIn);
        this.fireworkAge = 0;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        int i = 1;
        if (givenItem != null && givenItem.func_77942_o()) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)Optional.of((Object)givenItem));
            NBTTagCompound nbttagcompound = givenItem.func_77978_p();
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Fireworks");
            i += nbttagcompound1.func_74771_c("Flight");
        }
        this.field_70159_w = this.field_70146_Z.nextGaussian() * 0.001;
        this.field_70179_y = this.field_70146_Z.nextGaussian() * 0.001;
        this.field_70181_x = 0.05;
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIREWORK_ITEM, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        this.field_70159_w *= 1.15;
        this.field_70179_y *= 1.15;
        this.field_70181_x += 0.04;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.fireworkAge == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.fireworkAge;
        if (this.field_70170_p.field_72995_K && this.fireworkAge % 2 < 2) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t, this.field_70163_u - 0.3, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.field_70181_x * 0.5, this.field_70146_Z.nextGaussian() * 0.05, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K && this.fireworkAge > this.lifetime) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)17);
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemstack = (ItemStack)((Optional)this.field_70180_af.func_187225_a(FIREWORK_ITEM)).orNull();
            NBTTagCompound nbttagcompound = null;
            if (itemstack != null && itemstack.func_77942_o()) {
                nbttagcompound = itemstack.func_77978_p().func_74775_l("Fireworks");
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a(EntityParticlePopcornFX.generatePopcornParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, nbttagcompound, this.fireworkAge));
        }
        super.func_70103_a(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public static void registerFixesFireworkRocket(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData("FireworksRocketEntity", new String[]{"FireworksItem"}));
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Life", this.fireworkAge);
        compound.func_74768_a("LifeTime", this.lifetime);
        ItemStack itemstack = (ItemStack)((Optional)this.field_70180_af.func_187225_a(FIREWORK_ITEM)).orNull();
        if (itemstack != null) {
            compound.func_74782_a("FireworksItem", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        ItemStack itemstack;
        this.fireworkAge = compound.func_74762_e("Life");
        this.lifetime = compound.func_74762_e("LifeTime");
        NBTTagCompound nbttagcompound = compound.func_74775_l("FireworksItem");
        if (nbttagcompound != null && (itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound)) != null) {
            this.field_70180_af.func_187227_b(FIREWORK_ITEM, (Object)Optional.of((Object)itemstack));
        }
    }

    public float func_70013_c(float partialTicks) {
        return super.func_70013_c(partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return super.func_70070_b(partialTicks);
    }

    public boolean func_70075_an() {
        return false;
    }
}

